#!/usr/bin/env bash



# set -e: exit on errors
# set -x: verbose logging

set -x



# Configure bash globbing for recursive cp command

shopt -s globstar



# Set variables

PORT="_build/Hypatia's Mario Craft 64 (Ghostship)"

echo -n "Type dds if you converted the textures to that format, otherwise just press enter to use PNG (default): "
read VALUE

case "$VALUE" in

  dds)
    EXT=".dds"
    ;;

  *)
    EXT=".png"
    ;;
esac



# Remove and recreate work directories

rm -drf "$PORT"
rm -drf "_temp"

mkdir -p "$PORT"
mkdir -p "_temp"



# Copy textures to work directories

cp -r "Ports/Ghostship/"* "$PORT"
cp **"/SUPER MARIO 64"*"$EXT" "_temp"



# Create directories

mkdir -p "$PORT/actors/amp"
mkdir -p "$PORT/actors/blue_coin_switch"
mkdir -p "$PORT/actors/blue_fish"
mkdir -p "$PORT/actors/bobomb"
mkdir -p "$PORT/actors/bomb"
mkdir -p "$PORT/actors/boo"
mkdir -p "$PORT/actors/boo_castle"
mkdir -p "$PORT/actors/book"
mkdir -p "$PORT/actors/bookend"
mkdir -p "$PORT/actors/bowser"
mkdir -p "$PORT/actors/bowser_flame"
mkdir -p "$PORT/actors/breakable_box"
mkdir -p "$PORT/actors/bub"
mkdir -p "$PORT/actors/bubba"
mkdir -p "$PORT/actors/bubble"
mkdir -p "$PORT/actors/bullet_bill"
mkdir -p "$PORT/actors/bully"
mkdir -p "$PORT/actors/burn_smoke"
mkdir -p "$PORT/actors/butterfly"
mkdir -p "$PORT/actors/cannon_barrel"
mkdir -p "$PORT/actors/cannon_base"
mkdir -p "$PORT/actors/cannon_lid"
mkdir -p "$PORT/actors/capswitch"
mkdir -p "$PORT/actors/chain_ball"
mkdir -p "$PORT/actors/chain_chomp"
mkdir -p "$PORT/actors/chair"
mkdir -p "$PORT/actors/checkerboard_platform"
mkdir -p "$PORT/actors/chillychief"
mkdir -p "$PORT/actors/chuckya"
mkdir -p "$PORT/actors/clam_shell"
mkdir -p "$PORT/actors/coin"
mkdir -p "$PORT/actors/cyan_fish"
mkdir -p "$PORT/actors/dirt"
mkdir -p "$PORT/actors/door"
mkdir -p "$PORT/actors/dorrie"
mkdir -p "$PORT/actors/exclamation_box"
mkdir -p "$PORT/actors/exclamation_box_outline"
mkdir -p "$PORT/actors/explosion"
mkdir -p "$PORT/actors/eyerok"
mkdir -p "$PORT/actors/flame"
mkdir -p "$PORT/actors/flyguy"
mkdir -p "$PORT/actors/fwoosh"
mkdir -p "$PORT/actors/goomba"
mkdir -p "$PORT/actors/haunted_cage"
mkdir -p "$PORT/actors/heart"
mkdir -p "$PORT/actors/heave_ho"
mkdir -p "$PORT/actors/hoot"
mkdir -p "$PORT/actors/impact_ring"
mkdir -p "$PORT/actors/impact_smoke"
mkdir -p "$PORT/actors/king_bobomb"
mkdir -p "$PORT/actors/klepto"
mkdir -p "$PORT/actors/koopa"
mkdir -p "$PORT/actors/koopa_flag"
mkdir -p "$PORT/actors/koopa_shell"
mkdir -p "$PORT/actors/lakitu_cameraman"
mkdir -p "$PORT/actors/lakitu_enemy"
mkdir -p "$PORT/actors/leaves"
mkdir -p "$PORT/actors/mad_piano"
mkdir -p "$PORT/actors/manta"
mkdir -p "$PORT/actors/mario"
mkdir -p "$PORT/actors/mario_cap"
mkdir -p "$PORT/actors/metal_box"
mkdir -p "$PORT/actors/mips"
mkdir -p "$PORT/actors/mist"
mkdir -p "$PORT/actors/moneybag"
mkdir -p "$PORT/actors/monty_mole"
mkdir -p "$PORT/actors/monty_mole_hole"
mkdir -p "$PORT/actors/mr_i_eyeball"
mkdir -p "$PORT/actors/mr_i_iris"
mkdir -p "$PORT/actors/mushroom_1up"
mkdir -p "$PORT/actors/peach"
mkdir -p "$PORT/actors/pebble"
mkdir -p "$PORT/actors/penguin"
mkdir -p "$PORT/actors/piranha_plant"
mkdir -p "$PORT/actors/pokey"
mkdir -p "$PORT/actors/poundable_pole"
mkdir -p "$PORT/actors/power_meter"
mkdir -p "$PORT/actors/purple_switch"
mkdir -p "$PORT/actors/sand"
mkdir -p "$PORT/actors/scuttlebug"
mkdir -p "$PORT/actors/seaweed"
mkdir -p "$PORT/actors/skeeter"
mkdir -p "$PORT/actors/snowman"
mkdir -p "$PORT/actors/snufit"
mkdir -p "$PORT/actors/sparkle"
mkdir -p "$PORT/actors/sparkle_animation"
mkdir -p "$PORT/actors/spindrift"
mkdir -p "$PORT/actors/springboard"
mkdir -p "$PORT/actors/star"
mkdir -p "$PORT/actors/stomp_smoke"
mkdir -p "$PORT/actors/sushi"
mkdir -p "$PORT/actors/swoop"
mkdir -p "$PORT/actors/thwomp"
mkdir -p "$PORT/actors/toad"
mkdir -p "$PORT/actors/tornado"
mkdir -p "$PORT/actors/treasure_chest"
mkdir -p "$PORT/actors/tree"
mkdir -p "$PORT/actors/ukiki"
mkdir -p "$PORT/actors/unagi"
mkdir -p "$PORT/actors/walk_smoke"
mkdir -p "$PORT/actors/warp_pipe"
mkdir -p "$PORT/actors/water_bubble"
mkdir -p "$PORT/actors/water_mine"
mkdir -p "$PORT/actors/water_ring"
mkdir -p "$PORT/actors/water_splash"
mkdir -p "$PORT/actors/water_wave"
mkdir -p "$PORT/actors/whirlpool"
mkdir -p "$PORT/actors/white_particle"
mkdir -p "$PORT/actors/white_particle_small"
mkdir -p "$PORT/actors/whomp"
mkdir -p "$PORT/actors/wiggler"
mkdir -p "$PORT/actors/wooden_signpost"
mkdir -p "$PORT/actors/yellow_sphere"
mkdir -p "$PORT/actors/yellow_sphere_small"
mkdir -p "$PORT/actors/yoshi"
mkdir -p "$PORT/actors/yoshi_egg"
mkdir -p "$PORT/levels/bbh"
mkdir -p "$PORT/levels/bitdw"
mkdir -p "$PORT/levels/bitfs"
mkdir -p "$PORT/levels/bits"
mkdir -p "$PORT/levels/bob"
mkdir -p "$PORT/levels/bowser_1"
mkdir -p "$PORT/levels/bowser_2"
mkdir -p "$PORT/levels/bowser_3"
mkdir -p "$PORT/levels/castle_grounds"
mkdir -p "$PORT/levels/castle_inside"
mkdir -p "$PORT/levels/ccm"
mkdir -p "$PORT/levels/cotmc"
mkdir -p "$PORT/levels/ddd"
mkdir -p "$PORT/levels/ending"
mkdir -p "$PORT/levels/hmc"
mkdir -p "$PORT/levels/intro"
mkdir -p "$PORT/levels/jrb"
mkdir -p "$PORT/levels/lll"
mkdir -p "$PORT/levels/menu"
mkdir -p "$PORT/levels/pss"
mkdir -p "$PORT/levels/rr"
mkdir -p "$PORT/levels/sl"
mkdir -p "$PORT/levels/ssl"
mkdir -p "$PORT/levels/thi"
mkdir -p "$PORT/levels/totwc"
mkdir -p "$PORT/levels/ttc"
mkdir -p "$PORT/levels/ttm"
mkdir -p "$PORT/levels/vcutm"
mkdir -p "$PORT/levels/wdw"
mkdir -p "$PORT/levels/wf"
mkdir -p "$PORT/levels/wmotr"
mkdir -p "$PORT/textures/cave"
mkdir -p "$PORT/textures/effect"
mkdir -p "$PORT/textures/fire"
mkdir -p "$PORT/textures/generic"
mkdir -p "$PORT/textures/grass"
mkdir -p "$PORT/textures/inside"
mkdir -p "$PORT/textures/intro_raw"
mkdir -p "$PORT/textures/machine"
mkdir -p "$PORT/textures/mountain"
mkdir -p "$PORT/textures/outside"
mkdir -p "$PORT/textures/segment2"
mkdir -p "$PORT/textures/sky"
mkdir -p "$PORT/textures/skyboxes/bbh"
mkdir -p "$PORT/textures/skyboxes/bidw"
mkdir -p "$PORT/textures/skyboxes/bitfs"
mkdir -p "$PORT/textures/skyboxes/bits"
mkdir -p "$PORT/textures/skyboxes/ccm"
mkdir -p "$PORT/textures/skyboxes/cloud_floor"
mkdir -p "$PORT/textures/skyboxes/clouds"
mkdir -p "$PORT/textures/skyboxes/ssl"
mkdir -p "$PORT/textures/skyboxes/water"
mkdir -p "$PORT/textures/skyboxes/wdw"
mkdir -p "$PORT/textures/snow"
mkdir -p "$PORT/textures/spooky"
mkdir -p "$PORT/textures/title_screen_bg"
mkdir -p "$PORT/textures/water"



# Copy and rename textures

cp "_temp/SUPER MARIO 64#6F7DF292#0#2_all$EXT" "$PORT/actors/amp/amp_body$EXT"
cp "_temp/SUPER MARIO 64#86712A04#0#2_all$EXT" "$PORT/actors/amp/amp_electricity$EXT"
cp "_temp/SUPER MARIO 64#31764A00#0#2_all$EXT" "$PORT/actors/amp/amp_eyes$EXT"
cp "_temp/SUPER MARIO 64#88DC2D34#0#2_all$EXT" "$PORT/actors/amp/amp_mouth$EXT"

cp "_temp/SUPER MARIO 64#25EE1BA5#0#2_all$EXT" "$PORT/actors/blue_coin_switch/blue_coin_switch_side$EXT"
cp "_temp/SUPER MARIO 64#875630D6#0#2_all$EXT" "$PORT/actors/blue_coin_switch/blue_coin_switch_top$EXT"

cp "_temp/SUPER MARIO 64#FD9AA14E#0#2_all$EXT" "$PORT/actors/blue_fish/blue_fish$EXT"

cp "_temp/SUPER MARIO 64#585285D7#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_buddy_left_side$EXT"
cp "_temp/SUPER MARIO 64#292E5FD8#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_buddy_right_side$EXT"
cp "_temp/SUPER MARIO 64#2ED4BA24#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_eyes$EXT"
cp "_temp/SUPER MARIO 64#35456B51#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_eyes_blink$EXT"
cp "_temp/SUPER MARIO 64#A71D06B9#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_left_side$EXT"
cp "_temp/SUPER MARIO 64#38894888#0#2_all$EXT" "$PORT/actors/bobomb/bob-omb_right_side$EXT"

cp "_temp/SUPER MARIO 64#C82A46F3#0#2_all$EXT" "$PORT/actors/bomb/bomb_left_side$EXT"
cp "_temp/SUPER MARIO 64#C2050F68#0#2_all$EXT" "$PORT/actors/bomb/bomb_right_side$EXT"
cp "_temp/SUPER MARIO 64#AE1D5DC1#0#2_all$EXT" "$PORT/actors/bomb/bomb_spike$EXT"

cp "_temp/SUPER MARIO 64#B11FDC36#0#2_all$EXT" "$PORT/actors/boo/boo_eyes$EXT"
cp "_temp/SUPER MARIO 64#070E836F#0#2_all$EXT" "$PORT/actors/boo/boo_mouth$EXT"
cp "_temp/SUPER MARIO 64#B11FDC36#0#2_all$EXT" "$PORT/actors/boo_castle/bbh_boo_eyes$EXT"
cp "_temp/SUPER MARIO 64#070E836F#0#2_all$EXT" "$PORT/actors/boo_castle/bbh_boo_mouth$EXT"

cp "_temp/SUPER MARIO 64#8073DE72#0#2_all$EXT" "$PORT/actors/book/book_cover$EXT"
cp "_temp/SUPER MARIO 64#3E5AF02C#0#2_all$EXT" "$PORT/actors/book/bookend_seg5_texture_05000C60$EXT"
cp "_temp/SUPER MARIO 64#8073DE72#0#2_all$EXT" "$PORT/actors/bookend/bookend_cover$EXT"
cp "_temp/SUPER MARIO 64#F6BEEB24#0#2_all$EXT" "$PORT/actors/bookend/bookend_mouth$EXT"
cp "_temp/SUPER MARIO 64#3E5AF02C#0#2_all$EXT" "$PORT/actors/bookend/bookend_pages$EXT"
cp "_temp/SUPER MARIO 64#6D083A48#0#2_all$EXT" "$PORT/actors/bookend/bookend_spine$EXT"
cp "_temp/SUPER MARIO 64#37F10A8C#0#2_all$EXT" "$PORT/actors/bookend/bookend_tooth$EXT"

cp "_temp/SUPER MARIO 64#61AFCDD5#0#2_all$EXT" "$PORT/actors/bowser/bowser_armband$EXT"
cp "_temp/SUPER MARIO 64#374E253A#0#2_all$EXT" "$PORT/actors/bowser/bowser_armband_spike$EXT"
cp "_temp/SUPER MARIO 64#6E6A49EF#0#2_all$EXT" "$PORT/actors/bowser/bowser_body$EXT"
cp "_temp/SUPER MARIO 64#55620576#0#2_all$EXT" "$PORT/actors/bowser/bowser_chest$EXT"
cp "_temp/SUPER MARIO 64#E351CFF2#0#2_all$EXT" "$PORT/actors/bowser/bowser_claw_edge$EXT"
cp "_temp/SUPER MARIO 64#8D6B1DF6#0#2_all$EXT" "$PORT/actors/bowser/bowser_claw_horn_angle$EXT"
cp "_temp/SUPER MARIO 64#DAD0C429#0#2_all$EXT" "$PORT/actors/bowser/bowser_claw_horn_tooth$EXT"
cp "_temp/SUPER MARIO 64#6B3A40A5#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_center_0$EXT"
cp "_temp/SUPER MARIO 64#6B3A40A5#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_center_1$EXT"
cp "_temp/SUPER MARIO 64#39CC9592#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_closed_0$EXT"
cp "_temp/SUPER MARIO 64#39CC9592#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_closed_1$EXT"
cp "_temp/SUPER MARIO 64#D405BFC1#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_far_left_0$EXT"
cp "_temp/SUPER MARIO 64#D405BFC1#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_far_left_1$EXT"
cp "_temp/SUPER MARIO 64#2E0C1E02#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_half_closed_0$EXT"
cp "_temp/SUPER MARIO 64#2E0C1E02#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_half_closed_1$EXT"
cp "_temp/SUPER MARIO 64#7B84A495#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_left_0$EXT"
cp "_temp/SUPER MARIO 64#7B84A495#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_left_1$EXT"
cp "_temp/SUPER MARIO 64#A0869522#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_right_0$EXT"
cp "_temp/SUPER MARIO 64#A0869522#0#2_all$EXT" "$PORT/actors/bowser/bowser_eye_right_1$EXT"
cp "_temp/SUPER MARIO 64#6AF6B17F#0#2_all$EXT" "$PORT/actors/bowser/bowser_eyebrow$EXT"
cp "_temp/SUPER MARIO 64#9759DCD0#0#2_all$EXT" "$PORT/actors/bowser/bowser_hair$EXT"
cp "_temp/SUPER MARIO 64#D813A5E5#0#2_all$EXT" "$PORT/actors/bowser/bowser_muzzle$EXT"
cp "_temp/SUPER MARIO 64#F148AE1E#0#2_all$EXT" "$PORT/actors/bowser/bowser_nostrils$EXT"
cp "_temp/SUPER MARIO 64#386A9785#0#2_all$EXT" "$PORT/actors/bowser/bowser_shell$EXT"
cp "_temp/SUPER MARIO 64#7EB3FE85#0#2_all$EXT" "$PORT/actors/bowser/bowser_shell_edge$EXT"
cp "_temp/SUPER MARIO 64#F66CA88B#0#2_all$EXT" "$PORT/actors/bowser/bowser_tongue$EXT"
cp "_temp/SUPER MARIO 64#514A29BC#0#2_all$EXT" "$PORT/actors/bowser/bowser_upper_face$EXT"

cp "_temp/SUPER MARIO 64#41FDBC76#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_0$EXT"
cp "_temp/SUPER MARIO 64#6ED6659F#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_1$EXT"
cp "_temp/SUPER MARIO 64#DB8655FD#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_2$EXT"
cp "_temp/SUPER MARIO 64#D12D02E4#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_3$EXT"
cp "_temp/SUPER MARIO 64#F5D23B55#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_4$EXT"
cp "_temp/SUPER MARIO 64#5D54105C#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_5$EXT"
cp "_temp/SUPER MARIO 64#B8B08A8F#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_6$EXT"
cp "_temp/SUPER MARIO 64#838795F8#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_7$EXT"
cp "_temp/SUPER MARIO 64#E280555D#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_8$EXT"
cp "_temp/SUPER MARIO 64#29636778#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_9$EXT"
cp "_temp/SUPER MARIO 64#4A7E7508#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_10$EXT"
cp "_temp/SUPER MARIO 64#B534B831#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_11$EXT"
cp "_temp/SUPER MARIO 64#523F2F3F#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_12$EXT"
cp "_temp/SUPER MARIO 64#897D9B14#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_13$EXT"
cp "_temp/SUPER MARIO 64#03249A62#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_14$EXT"
cp "_temp/SUPER MARIO 64#61EC3940#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_15$EXT"
cp "_temp/SUPER MARIO 64#871045E4#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_16$EXT"
cp "_temp/SUPER MARIO 64#0ED8D758#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_17$EXT"
cp "_temp/SUPER MARIO 64#5FD6CCEC#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_18$EXT"
cp "_temp/SUPER MARIO 64#A46186FA#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_19$EXT"
cp "_temp/SUPER MARIO 64#FD1AA928#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_20$EXT"
cp "_temp/SUPER MARIO 64#63F46B6E#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_21$EXT"
cp "_temp/SUPER MARIO 64#095FC27A#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_22$EXT"
cp "_temp/SUPER MARIO 64#54E749EC#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_23$EXT"
cp "_temp/SUPER MARIO 64#7473E7A4#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_24$EXT"
cp "_temp/SUPER MARIO 64#B853043B#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_25$EXT"
cp "_temp/SUPER MARIO 64#A4F69A2F#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_26$EXT"
cp "_temp/SUPER MARIO 64#5E9F5DF4#0#2_all$EXT" "$PORT/actors/bowser_flame/bowser_flame_27$EXT"

cp "_temp/SUPER MARIO 64#FDDF5C31#0#2_all$EXT" "$PORT/actors/breakable_box/cork_box_surface$EXT"
cp "_temp/SUPER MARIO 64#C9F30BAF#0#2_all$EXT" "$PORT/actors/breakable_box/crazy_box_surface$EXT"

cp "_temp/SUPER MARIO 64#761B53E2#0#2_all$EXT" "$PORT/actors/bub/bub_eye_border$EXT"
cp "_temp/SUPER MARIO 64#FC53C33B#0#2_all$EXT" "$PORT/actors/bub/bub_eyes$EXT"
cp "_temp/SUPER MARIO 64#A11454A9#0#2_all$EXT" "$PORT/actors/bub/bub_fins$EXT"
cp "_temp/SUPER MARIO 64#2DEC812E#0#2_all$EXT" "$PORT/actors/bub/bub_scales$EXT"
cp "_temp/SUPER MARIO 64#761B53E2#0#2_all$EXT" "$PORT/actors/bubba/bubba_eye_border$EXT"
cp "_temp/SUPER MARIO 64#FC53C33B#0#2_all$EXT" "$PORT/actors/bubba/bubba_eyes_unused$EXT"
cp "_temp/SUPER MARIO 64#A11454A9#0#2_all$EXT" "$PORT/actors/bubba/bubba_fins$EXT"
cp "_temp/SUPER MARIO 64#2DEC812E#0#2_all$EXT" "$PORT/actors/bubba/bubba_scales$EXT"
cp "_temp/SUPER MARIO 64#BF952514#0#2_all$EXT" "$PORT/actors/bubba/bubba_sunglasses$EXT"

cp "_temp/SUPER MARIO 64#DCC12774#0#2_all$EXT" "$PORT/actors/bubble/bubble$EXT"
cp "_temp/SUPER MARIO 64#5DFA73AC#0#2_all$EXT" "$PORT/actors/bubble/mr_i_bubble$EXT"

cp "_temp/SUPER MARIO 64#35BBD200#0#2_all$EXT" "$PORT/actors/bullet_bill/bullet_bill_eye$EXT"
cp "_temp/SUPER MARIO 64#03298536#0#2_all$EXT" "$PORT/actors/bullet_bill/bullet_bill_mouth$EXT"

cp "_temp/SUPER MARIO 64#21247806#0#2_all$EXT" "$PORT/actors/bully/bully_eye$EXT"
cp "_temp/SUPER MARIO 64#D35575D6#0#2_all$EXT" "$PORT/actors/bully/bully_horn$EXT"
cp "_temp/SUPER MARIO 64#09CABB08#0#2_all$EXT" "$PORT/actors/bully/bully_left_side$EXT"
cp "_temp/SUPER MARIO 64#36D9C81E#0#2_all$EXT" "$PORT/actors/bully/bully_right_side$EXT"

cp "_temp/SUPER MARIO 64#D3A287BB#0#2_all$EXT" "$PORT/actors/burn_smoke/burn_smoke$EXT"

cp "_temp/SUPER MARIO 64#26DFC97D#0#2_all$EXT" "$PORT/actors/butterfly/butterfly_wing$EXT"

cp "_temp/SUPER MARIO 64#94776F27#0#2_all$EXT" "$PORT/actors/cannon_barrel/cannon_barrel$EXT"
cp "_temp/SUPER MARIO 64#0612269D#0#2_all$EXT" "$PORT/actors/cannon_base/cannon_base$EXT"
cp "_temp/SUPER MARIO 64#E0BB9B61#0#2_all$EXT" "$PORT/actors/cannon_lid/cannon_lid$EXT"

cp "_temp/SUPER MARIO 64#1F71DA85#0#2_all$EXT" "$PORT/actors/capswitch/cap_switch_base$EXT"
cp "_temp/SUPER MARIO 64#D2A05119#3#2_all$EXT" "$PORT/actors/capswitch/cap_switch_head$EXT"

cp "_temp/SUPER MARIO 64#CB4982B2#0#2_all$EXT" "$PORT/actors/chain_ball/chain_ball$EXT"
cp "_temp/SUPER MARIO 64#8AC74230#0#2_all$EXT" "$PORT/actors/chain_chomp/chain_chomp_bright_shine$EXT"
cp "_temp/SUPER MARIO 64#01A60CCD#0#2_all$EXT" "$PORT/actors/chain_chomp/chain_chomp_dull_shine$EXT"
cp "_temp/SUPER MARIO 64#B267FDF0#0#2_all$EXT" "$PORT/actors/chain_chomp/chain_chomp_eye$EXT"
cp "_temp/SUPER MARIO 64#354089BB#0#2_all$EXT" "$PORT/actors/chain_chomp/chain_chomp_tongue$EXT"
cp "_temp/SUPER MARIO 64#09740389#0#2_all$EXT" "$PORT/actors/chain_chomp/chain_chomp_tooth$EXT"

cp "_temp/SUPER MARIO 64#1195AECC#0#2_all$EXT" "$PORT/actors/chair/chair_bottom$EXT"
cp "_temp/SUPER MARIO 64#1198C8AB#0#2_all$EXT" "$PORT/actors/chair/chair_front$EXT"
cp "_temp/SUPER MARIO 64#21BFEA1A#0#2_all$EXT" "$PORT/actors/chair/chair_leg$EXT"
cp "_temp/SUPER MARIO 64#A6E1B26B#0#2_all$EXT" "$PORT/actors/chair/chair_surface_unused$EXT"

cp "_temp/SUPER MARIO 64#BC16978D#0#2_all$EXT" "$PORT/actors/checkerboard_platform/checkerboard_platform$EXT"
cp "_temp/SUPER MARIO 64#3486BF66#0#2_all$EXT" "$PORT/actors/checkerboard_platform/checkerboard_platform_side$EXT"

cp "_temp/SUPER MARIO 64#21247806#0#2_all$EXT" "$PORT/actors/chillychief/chill_bully_eye$EXT"
cp "_temp/SUPER MARIO 64#00866B3F#0#2_all$EXT" "$PORT/actors/chillychief/chill_bully_left_side$EXT"
cp "_temp/SUPER MARIO 64#B4AA0E1C#0#2_all$EXT" "$PORT/actors/chillychief/chill_bully_right_side$EXT"

cp "_temp/SUPER MARIO 64#1501AD26#0#2_all$EXT" "$PORT/actors/chuckya/chuckya_body_arm_left_side$EXT"
cp "_temp/SUPER MARIO 64#33EA5D90#0#2_all$EXT" "$PORT/actors/chuckya/chuckya_body_arm_right_side$EXT"
cp "_temp/SUPER MARIO 64#7B7A6AD1#0#2_all$EXT" "$PORT/actors/chuckya/chuckya_hand_antenna$EXT"

cp "_temp/SUPER MARIO 64#679A4C71#0#2_all$EXT" "$PORT/actors/clam_shell/clam_shell$EXT"
cp "_temp/SUPER MARIO 64#F97DC072#0#2_all$EXT" "$PORT/actors/clam_shell/clam_shell_mouth$EXT"

cp "_temp/SUPER MARIO 64#6906C074#3#2_all$EXT" "$PORT/actors/coin/coin_front$EXT"
cp "_temp/SUPER MARIO 64#E5BCF46E#3#2_all$EXT" "$PORT/actors/coin/coin_side$EXT"
cp "_temp/SUPER MARIO 64#176C2E93#3#2_all$EXT" "$PORT/actors/coin/coin_tilt_left$EXT"
cp "_temp/SUPER MARIO 64#FBE08CAB#3#2_all$EXT" "$PORT/actors/coin/coin_tilt_right$EXT"

cp "_temp/SUPER MARIO 64#2563BF4C#0#2_all$EXT" "$PORT/actors/cyan_fish/cyan_fish$EXT"

cp "_temp/SUPER MARIO 64#F21F608E#0#2_all$EXT" "$PORT/actors/dirt/dirt_particle$EXT"

cp "_temp/SUPER MARIO 64#401B923F#0#2_all$EXT" "$PORT/actors/door/bbh_door$EXT"
cp "_temp/SUPER MARIO 64#9A5A2FB3#0#2_all$EXT" "$PORT/actors/door/bbh_door_overlay$EXT"
cp "_temp/SUPER MARIO 64#BBC6B061#0#2_all$EXT" "$PORT/actors/door/door_lock$EXT"
cp "_temp/SUPER MARIO 64#877137A9#0#2_all$EXT" "$PORT/actors/door/hmc_mural_door$EXT"
cp "_temp/SUPER MARIO 64#9C977CFF#0#2_all$EXT" "$PORT/actors/door/hmc_mural_door_overlay$EXT"
cp "_temp/SUPER MARIO 64#2F5F1297#0#2_all$EXT" "$PORT/actors/door/metal_door$EXT"
cp "_temp/SUPER MARIO 64#93D4EE01#0#2_all$EXT" "$PORT/actors/door/metal_door_overlay$EXT"
cp "_temp/SUPER MARIO 64#0DF6BDFF#0#2_all$EXT" "$PORT/actors/door/one_star_door_sign$EXT"
cp "_temp/SUPER MARIO 64#FD820701#0#2_all$EXT" "$PORT/actors/door/polished_wooden_door$EXT"
cp "_temp/SUPER MARIO 64#9965C006#0#2_all$EXT" "$PORT/actors/door/polished_wooden_door_overlay$EXT"
cp "_temp/SUPER MARIO 64#12733B4F#0#2_all$EXT" "$PORT/actors/door/rough_wooden_door$EXT"
cp "_temp/SUPER MARIO 64#4EB8714C#0#2_all$EXT" "$PORT/actors/door/rough_wooden_door_overlay$EXT"
cp "_temp/SUPER MARIO 64#C99B5909#0#2_all$EXT" "$PORT/actors/door/three_star_door_sign$EXT"
cp "_temp/SUPER MARIO 64#2AAB5196#0#2_all$EXT" "$PORT/actors/door/zero_star_door_sign$EXT"

cp "_temp/SUPER MARIO 64#FD57EA27#0#2_all$EXT" "$PORT/actors/dorrie/dorrie_eye$EXT"
cp "_temp/SUPER MARIO 64#6C902269#0#2_all$EXT" "$PORT/actors/dorrie/dorrie_skin$EXT"
cp "_temp/SUPER MARIO 64#354089BB#0#2_all$EXT" "$PORT/actors/dorrie/dorrie_tongue$EXT"

cp "_temp/SUPER MARIO 64#23F84D6A#0#2_all$EXT" "$PORT/actors/exclamation_box/exclamation_box_front$EXT"
cp "_temp/SUPER MARIO 64#428D4124#0#2_all$EXT" "$PORT/actors/exclamation_box/exclamation_box_side$EXT"
cp "_temp/SUPER MARIO 64#7E5C3A04#0#2_all$EXT" "$PORT/actors/exclamation_box/metal_cap_box_front$EXT"
cp "_temp/SUPER MARIO 64#8413A8FA#0#2_all$EXT" "$PORT/actors/exclamation_box/metal_cap_box_side$EXT"
cp "_temp/SUPER MARIO 64#7EBE7D5E#0#2_all$EXT" "$PORT/actors/exclamation_box/vanish_cap_box_front$EXT"
cp "_temp/SUPER MARIO 64#B16EDFA9#0#2_all$EXT" "$PORT/actors/exclamation_box/vanish_cap_box_side$EXT"
cp "_temp/SUPER MARIO 64#A765AAA8#0#2_all$EXT" "$PORT/actors/exclamation_box/wing_cap_box_front$EXT"
cp "_temp/SUPER MARIO 64#4838A16E#0#2_all$EXT" "$PORT/actors/exclamation_box/wing_cap_box_side$EXT"
cp "_temp/SUPER MARIO 64#1F04DAF4#0#2_all$EXT" "$PORT/actors/exclamation_box_outline/exclamation_box_outline$EXT"
cp "_temp/SUPER MARIO 64#D17F99C6#0#2_all$EXT" "$PORT/actors/exclamation_box_outline/exclamation_point$EXT"

cp "_temp/SUPER MARIO 64#1E834EB0#0#2_all$EXT" "$PORT/actors/explosion/explosion_0$EXT"
cp "_temp/SUPER MARIO 64#FA421C73#0#2_all$EXT" "$PORT/actors/explosion/explosion_1$EXT"
cp "_temp/SUPER MARIO 64#1872FA6C#0#2_all$EXT" "$PORT/actors/explosion/explosion_2$EXT"
cp "_temp/SUPER MARIO 64#0B6D2926#0#2_all$EXT" "$PORT/actors/explosion/explosion_3$EXT"
cp "_temp/SUPER MARIO 64#B596CB90#0#2_all$EXT" "$PORT/actors/explosion/explosion_4$EXT"
cp "_temp/SUPER MARIO 64#42A20F7E#0#2_all$EXT" "$PORT/actors/explosion/explosion_5$EXT"
cp "_temp/SUPER MARIO 64#166DD880#0#2_all$EXT" "$PORT/actors/explosion/explosion_6$EXT"

cp "_temp/SUPER MARIO 64#C6028757#0#2_all$EXT" "$PORT/actors/eyerok/eyerok_bricks$EXT"
cp "_temp/SUPER MARIO 64#B9299E61#0#2_all$EXT" "$PORT/actors/eyerok/eyerok_eye_closed$EXT"
cp "_temp/SUPER MARIO 64#2C14636C#0#2_all$EXT" "$PORT/actors/eyerok/eyerok_eye_mostly_closed$EXT"
cp "_temp/SUPER MARIO 64#761E51A0#0#2_all$EXT" "$PORT/actors/eyerok/eyerok_eye_mostly_open$EXT"
cp "_temp/SUPER MARIO 64#93944D54#0#2_all$EXT" "$PORT/actors/eyerok/eyerok_eye_open$EXT"

cp "_temp/SUPER MARIO 64#A4841A07#3#2_all$EXT" "$PORT/actors/flame/flame_0$EXT"
cp "_temp/SUPER MARIO 64#28DF6C96#3#2_all$EXT" "$PORT/actors/flame/flame_1$EXT"
cp "_temp/SUPER MARIO 64#F0B319A6#3#2_all$EXT" "$PORT/actors/flame/flame_2$EXT"
cp "_temp/SUPER MARIO 64#DB4164D7#3#2_all$EXT" "$PORT/actors/flame/flame_3$EXT"
cp "_temp/SUPER MARIO 64#67AD777B#3#2_all$EXT" "$PORT/actors/flame/flame_4$EXT"
cp "_temp/SUPER MARIO 64#617BFB7B#3#2_all$EXT" "$PORT/actors/flame/flame_5$EXT"
cp "_temp/SUPER MARIO 64#4C6EDE9F#3#2_all$EXT" "$PORT/actors/flame/flame_6$EXT"
cp "_temp/SUPER MARIO 64#1AE70860#3#2_all$EXT" "$PORT/actors/flame/flame_7$EXT"

cp "_temp/SUPER MARIO 64#C833EF43#0#2_all$EXT" "$PORT/actors/flyguy/flyguy_cloth_wrinkle$EXT"
cp "_temp/SUPER MARIO 64#923C687E#0#2_all$EXT" "$PORT/actors/flyguy/flyguy_face$EXT"
cp "_temp/SUPER MARIO 64#20725250#3#2_all$EXT" "$PORT/actors/flyguy/flyguy_propeller$EXT"

cp "_temp/SUPER MARIO 64#DD432C19#3#2_all$EXT" "$PORT/actors/fwoosh/fwoosh_face$EXT"

cp "_temp/SUPER MARIO 64#FD83B121#0#2_all$EXT" "$PORT/actors/goomba/goomba_body$EXT"
cp "_temp/SUPER MARIO 64#C6A1C158#0#2_all$EXT" "$PORT/actors/goomba/goomba_face$EXT"
cp "_temp/SUPER MARIO 64#384E2A31#0#2_all$EXT" "$PORT/actors/goomba/goomba_face_blink$EXT"

cp "_temp/SUPER MARIO 64#1C62CC15#0#2_all$EXT" "$PORT/actors/haunted_cage/bbh_cage_bars$EXT"
cp "_temp/SUPER MARIO 64#4443D529#0#2_all$EXT" "$PORT/actors/haunted_cage/bbh_cage_double_ornament$EXT"
cp "_temp/SUPER MARIO 64#A4AF5230#0#2_all$EXT" "$PORT/actors/haunted_cage/bbh_cage_floor$EXT"
cp "_temp/SUPER MARIO 64#EDA45656#0#2_all$EXT" "$PORT/actors/haunted_cage/bbh_cage_ornament$EXT"
cp "_temp/SUPER MARIO 64#49313621#0#2_all$EXT" "$PORT/actors/haunted_cage/bbh_cage_wooden_base$EXT"

cp "_temp/SUPER MARIO 64#CD5F7595#0#2_all$EXT" "$PORT/actors/heart/spinning_heart$EXT"

cp "_temp/SUPER MARIO 64#6E489603#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_arm_ornament$EXT"
cp "_temp/SUPER MARIO 64#890B9632#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_face$EXT"
cp "_temp/SUPER MARIO 64#9B650ED0#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_logo$EXT"
cp "_temp/SUPER MARIO 64#6C5CC56F#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_platform$EXT"
cp "_temp/SUPER MARIO 64#0E40FA10#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_roller$EXT"
cp "_temp/SUPER MARIO 64#3B111D77#0#2_all$EXT" "$PORT/actors/heave_ho/heave-ho_turnkey$EXT"

cp "_temp/SUPER MARIO 64#9DF33CC7#0#2_all$EXT" "$PORT/actors/hoot/hoot_eyes$EXT"
cp "_temp/SUPER MARIO 64#0CE27CD0#0#2_all$EXT" "$PORT/actors/hoot/hoot_wing$EXT"
cp "_temp/SUPER MARIO 64#1F8B71CA#0#2_all$EXT" "$PORT/actors/hoot/hoot_wing_tip$EXT"

cp "_temp/SUPER MARIO 64#3CF309E4#3#2_all$EXT" "$PORT/actors/impact_ring/impact_ring_left_side$EXT"
cp "_temp/SUPER MARIO 64#20655B3C#3#2_all$EXT" "$PORT/actors/impact_ring/impact_ring_right_side$EXT"

cp "_temp/SUPER MARIO 64#1E263631#3#2_all$EXT" "$PORT/actors/impact_smoke/impact_smoke_2$EXT"
cp "_temp/SUPER MARIO 64#D333CC90#3#2_all$EXT" "$PORT/actors/impact_smoke/impact_smoke_3$EXT"

cp "_temp/SUPER MARIO 64#F7844A94#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_arm$EXT"
cp "_temp/SUPER MARIO 64#2996CA88#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_crown_rim$EXT"
cp "_temp/SUPER MARIO 64#2ED4BA24#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_eyes$EXT"
cp "_temp/SUPER MARIO 64#35456B51#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_eyes_blink$EXT"
cp "_temp/SUPER MARIO 64#8E41FFCD#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_hand$EXT"
cp "_temp/SUPER MARIO 64#886B2FF9#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_left_side$EXT"
cp "_temp/SUPER MARIO 64#808C10C2#0#2_all$EXT" "$PORT/actors/king_bobomb/king_bob-omb_right_side$EXT"

cp "_temp/SUPER MARIO 64#0E7107E3#0#2_all$EXT" "$PORT/actors/klepto/klepto_beak$EXT"
cp "_temp/SUPER MARIO 64#90581231#0#2_all$EXT" "$PORT/actors/klepto/klepto_chest_tuft$EXT"
cp "_temp/SUPER MARIO 64#C3F5C275#0#2_all$EXT" "$PORT/actors/klepto/klepto_eye$EXT"
cp "_temp/SUPER MARIO 64#89B90233#0#2_all$EXT" "$PORT/actors/klepto/klepto_wing$EXT"
cp "_temp/SUPER MARIO 64#6ABEBFF0#0#2_all$EXT" "$PORT/actors/klepto/klepto_wing_flap$EXT"

cp "_temp/SUPER MARIO 64#852361B6#0#2_all$EXT" "$PORT/actors/koopa/koopa_eye_border$EXT"
cp "_temp/SUPER MARIO 64#29C0C7D2#0#2_all$EXT" "$PORT/actors/koopa/koopa_eyes_closed$EXT"
cp "_temp/SUPER MARIO 64#CBBC8294#0#2_all$EXT" "$PORT/actors/koopa/koopa_eyes_open$EXT"
cp "_temp/SUPER MARIO 64#0D9FD7E4#0#2_all$EXT" "$PORT/actors/koopa/koopa_nostrils$EXT"
cp "_temp/SUPER MARIO 64#5F035EC5#0#2_all$EXT" "$PORT/actors/koopa/koopa_shell_back$EXT"
cp "_temp/SUPER MARIO 64#62C94802#0#2_all$EXT" "$PORT/actors/koopa/koopa_shell_front$EXT"
cp "_temp/SUPER MARIO 64#86FB2F22#0#2_all$EXT" "$PORT/actors/koopa/koopa_shell_front_top$EXT"
cp "_temp/SUPER MARIO 64#3B0D1E46#0#2_all$EXT" "$PORT/actors/koopa/koopa_shoe$EXT"
cp "_temp/SUPER MARIO 64#D8903B0B#0#2_all$EXT" "$PORT/actors/koopa_flag/koopa_flag_banner$EXT"
cp "_temp/SUPER MARIO 64#5F035EC5#0#2_all$EXT" "$PORT/actors/koopa_shell/koopa_shell_back$EXT"
cp "_temp/SUPER MARIO 64#62C94802#0#2_all$EXT" "$PORT/actors/koopa_shell/koopa_shell_front$EXT"

cp "_temp/SUPER MARIO 64#0993E63E#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_camera_lens$EXT"
cp "_temp/SUPER MARIO 64#DB6C3044#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_cameraman_eyes_closed$EXT"
cp "_temp/SUPER MARIO 64#EAA27132#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_cameraman_eyes_open$EXT"
cp "_temp/SUPER MARIO 64#77290EB2#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_cameraman_frown$EXT"
cp "_temp/SUPER MARIO 64#5D617EA0#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_cameraman_shell$EXT"
cp "_temp/SUPER MARIO 64#85C9CDA3#0#2_all$EXT" "$PORT/actors/lakitu_cameraman/lakitu_cameraman_cloud_face_unused$EXT"
cp "_temp/SUPER MARIO 64#DB6C3044#0#2_all$EXT" "$PORT/actors/lakitu_enemy/lakitu_enemy_eyes_closed$EXT"
cp "_temp/SUPER MARIO 64#EAA27132#0#2_all$EXT" "$PORT/actors/lakitu_enemy/lakitu_enemy_eyes_open$EXT"
cp "_temp/SUPER MARIO 64#77290EB2#0#2_all$EXT" "$PORT/actors/lakitu_enemy/lakitu_enemy_frown$EXT"
cp "_temp/SUPER MARIO 64#5D617EA0#0#2_all$EXT" "$PORT/actors/lakitu_enemy/lakitu_enemy_shell$EXT"
cp "_temp/SUPER MARIO 64#85C9CDA3#0#2_all$EXT" "$PORT/actors/lakitu_enemy/lakitu_enemy_cloud_face_unused$EXT"

cp "_temp/SUPER MARIO 64#C4D1C3CE#0#2_all$EXT" "$PORT/actors/leaves/leaf$EXT"

cp "_temp/SUPER MARIO 64#FD6AF08F#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_body$EXT"
cp "_temp/SUPER MARIO 64#8213677C#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_keys$EXT"
cp "_temp/SUPER MARIO 64#A3C0D76F#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_keys_corner$EXT"
cp "_temp/SUPER MARIO 64#C9A1F57E#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_keys_edge$EXT"
cp "_temp/SUPER MARIO 64#FB38796A#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_mouth$EXT"
cp "_temp/SUPER MARIO 64#09740389#0#2_all$EXT" "$PORT/actors/mad_piano/mad_piano_tooth$EXT"

cp "_temp/SUPER MARIO 64#1203BAA7#0#2_all$EXT" "$PORT/actors/manta/manta_eye$EXT"
cp "_temp/SUPER MARIO 64#8C1EBB7F#0#2_all$EXT" "$PORT/actors/manta/manta_fin_corner$EXT"
cp "_temp/SUPER MARIO 64#9B42ABEA#0#2_all$EXT" "$PORT/actors/manta/manta_fin_edge$EXT"
cp "_temp/SUPER MARIO 64#D2EBC589#0#2_all$EXT" "$PORT/actors/manta/manta_gills$EXT"

cp "_temp/SUPER MARIO 64#6B8D43C4#0#2_all$EXT" "$PORT/actors/mario/mario_eyes_center$EXT"
cp "_temp/SUPER MARIO 64#5D6B0678#0#2_all$EXT" "$PORT/actors/mario/mario_eyes_closed$EXT"
cp "_temp/SUPER MARIO 64#28964B59#0#2_all$EXT" "$PORT/actors/mario/mario_eyes_dead$EXT"
cp "_temp/SUPER MARIO 64#9FBECEF9#0#2_all$EXT" "$PORT/actors/mario/mario_eyes_half_closed$EXT"
cp "_temp/SUPER MARIO 64#905D3214#0#2_all$EXT" "$PORT/actors/mario/mario_logo$EXT"
cp "_temp/SUPER MARIO 64#432D56BE#0#2_all$EXT" "$PORT/actors/mario/mario_metal$EXT"
cp "_temp/SUPER MARIO 64#E9FCBF74#0#2_all$EXT" "$PORT/actors/mario/mario_mustache$EXT"
cp "_temp/SUPER MARIO 64#19442FC9#0#2_all$EXT" "$PORT/actors/mario/mario_overalls_button$EXT"
cp "_temp/SUPER MARIO 64#2BEA0A29#0#2_all$EXT" "$PORT/actors/mario/mario_sideburn$EXT"
cp "_temp/SUPER MARIO 64#17C50CF2#0#2_all$EXT" "$PORT/actors/mario/mario_wing$EXT"
cp "_temp/SUPER MARIO 64#387D6D33#0#2_all$EXT" "$PORT/actors/mario/mario_wing_tip$EXT"
cp "_temp/SUPER MARIO 64#BFA0470C#0#2_all$EXT" "$PORT/actors/mario/mario_metal_wing_unused$EXT"
cp "_temp/SUPER MARIO 64#5F995294#0#2_all$EXT" "$PORT/actors/mario/mario_metal_wing_tip_unused$EXT"

cp "_temp/SUPER MARIO 64#905D3214#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_logo$EXT"
cp "_temp/SUPER MARIO 64#432D56BE#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_metal$EXT"
cp "_temp/SUPER MARIO 64#17C50CF2#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_wing$EXT"
cp "_temp/SUPER MARIO 64#387D6D33#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_wing_tip$EXT"
cp "_temp/SUPER MARIO 64#BFA0470C#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_metal_wing_unused$EXT"
cp "_temp/SUPER MARIO 64#5F995294#0#2_all$EXT" "$PORT/actors/mario_cap/mario_cap_metal_wing_tip_unused$EXT"

cp "_temp/SUPER MARIO 64#946F580C#0#2_all$EXT" "$PORT/actors/metal_box/metal_box_side$EXT"

cp "_temp/SUPER MARIO 64#4944D2C9#0#2_all$EXT" "$PORT/actors/mips/mips_eyes$EXT"

cp "_temp/SUPER MARIO 64#7CE8869D#3#2_all$EXT" "$PORT/actors/mist/mist$EXT"

cp "_temp/SUPER MARIO 64#968EC1C4#0#2_all$EXT" "$PORT/actors/moneybag/moneybag_eyes$EXT"
cp "_temp/SUPER MARIO 64#E3548182#0#2_all$EXT" "$PORT/actors/moneybag/moneybag_mouth$EXT"

cp "_temp/SUPER MARIO 64#21F3A705#0#2_all$EXT" "$PORT/actors/monty_mole/monty_mole_cheek$EXT"
cp "_temp/SUPER MARIO 64#06343AFC#0#2_all$EXT" "$PORT/actors/monty_mole/monty_mole_claw$EXT"
cp "_temp/SUPER MARIO 64#3902D1B8#0#2_all$EXT" "$PORT/actors/monty_mole/monty_mole_eye$EXT"
cp "_temp/SUPER MARIO 64#04A6FFC8#0#2_all$EXT" "$PORT/actors/monty_mole/monty_mole_nose$EXT"
cp "_temp/SUPER MARIO 64#D6096833#0#2_all$EXT" "$PORT/actors/monty_mole/monty_mole_tooth$EXT"
cp "_temp/SUPER MARIO 64#81B554A7#3#2_all$EXT" "$PORT/actors/monty_mole_hole/monty_mole_hole$EXT"

cp "_temp/SUPER MARIO 64#02CFD740#0#2_all$EXT" "$PORT/actors/mr_i_eyeball/mr_i_eyeball_left_side$EXT"
cp "_temp/SUPER MARIO 64#87786913#0#2_all$EXT" "$PORT/actors/mr_i_eyeball/mr_i_eyeball_right_side$EXT"
cp "_temp/SUPER MARIO 64#A833E954#0#2_all$EXT" "$PORT/actors/mr_i_iris/mr_i_iris_closed$EXT"
cp "_temp/SUPER MARIO 64#78A6DB75#0#2_all$EXT" "$PORT/actors/mr_i_iris/mr_i_iris_mostly_closed$EXT"
cp "_temp/SUPER MARIO 64#5CC4BED3#0#2_all$EXT" "$PORT/actors/mr_i_iris/mr_i_iris_mostly_open$EXT"
cp "_temp/SUPER MARIO 64#2A93AFC0#0#2_all$EXT" "$PORT/actors/mr_i_iris/mr_i_iris_open$EXT"

cp "_temp/SUPER MARIO 64#A23342E2#0#2_all$EXT" "$PORT/actors/mushroom_1up/1-up_mushroom$EXT"

cp "_temp/SUPER MARIO 64#7E216E16#0#2_all$EXT" "$PORT/actors/peach/peach_chest_jewel$EXT"
cp "_temp/SUPER MARIO 64#DBF4274C#0#2_all$EXT" "$PORT/actors/peach/peach_crown_jewel$EXT"
cp "_temp/SUPER MARIO 64#F8775564#0#2_all$EXT" "$PORT/actors/peach/peach_dress$EXT"
cp "_temp/SUPER MARIO 64#ECACF737#0#2_all$EXT" "$PORT/actors/peach/peach_eye_closed$EXT"
cp "_temp/SUPER MARIO 64#7B8E4AC2#0#2_all$EXT" "$PORT/actors/peach/peach_eye_mostly_closed$EXT"
cp "_temp/SUPER MARIO 64#03DAF3D5#0#2_all$EXT" "$PORT/actors/peach/peach_eye_mostly_open$EXT"
cp "_temp/SUPER MARIO 64#CC4FE796#0#2_all$EXT" "$PORT/actors/peach/peach_eye_open$EXT"
cp "_temp/SUPER MARIO 64#4FE1A0ED#0#2_all$EXT" "$PORT/actors/peach/peach_lips$EXT"
cp "_temp/SUPER MARIO 64#723EDCD4#0#2_all$EXT" "$PORT/actors/peach/peach_lips_scrunched$EXT"
cp "_temp/SUPER MARIO 64#B7C60055#0#2_all$EXT" "$PORT/actors/peach/peach_nostril$EXT"

cp "_temp/SUPER MARIO 64#5535F203#0#2_all$EXT" "$PORT/actors/pebble/pebble$EXT"

cp "_temp/SUPER MARIO 64#78B59E82#0#2_all$EXT" "$PORT/actors/penguin/penguin_beak$EXT"
cp "_temp/SUPER MARIO 64#6C131FEF#0#2_all$EXT" "$PORT/actors/penguin/penguin_eye_angry$EXT"
cp "_temp/SUPER MARIO 64#180BDE92#0#2_all$EXT" "$PORT/actors/penguin/penguin_eye_closed$EXT"
cp "_temp/SUPER MARIO 64#578AA0E9#0#2_all$EXT" "$PORT/actors/penguin/penguin_eye_half_closed$EXT"
cp "_temp/SUPER MARIO 64#B2DBCCAE#0#2_all$EXT" "$PORT/actors/penguin/penguin_eye_open$EXT"
cp "_temp/SUPER MARIO 64#6D8F004D#0#2_all$EXT" "$PORT/actors/penguin/penguin_eye_angry_unused$EXT"

cp "_temp/SUPER MARIO 64#5AEA7079#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_bottom_lip$EXT"
cp "_temp/SUPER MARIO 64#5BC5CA75#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_leaf$EXT"
cp "_temp/SUPER MARIO 64#373DF028#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_skin$EXT"
cp "_temp/SUPER MARIO 64#29F15A68#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_stem$EXT"
cp "_temp/SUPER MARIO 64#F66CA88B#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_tongue$EXT"
cp "_temp/SUPER MARIO 64#85887EE4#0#2_all$EXT" "$PORT/actors/piranha_plant/piranha_plant_tooth$EXT"

cp "_temp/SUPER MARIO 64#2F25120F#0#2_all$EXT" "$PORT/actors/pokey/pokey_body$EXT"
cp "_temp/SUPER MARIO 64#B8A77D4D#0#2_all$EXT" "$PORT/actors/pokey/pokey_face$EXT"
cp "_temp/SUPER MARIO 64#36B1482F#0#2_all$EXT" "$PORT/actors/pokey/pokey_face_blink$EXT"

cp "_temp/SUPER MARIO 64#90027A49#0#2_all$EXT" "$PORT/actors/poundable_pole/poundable_pole_side$EXT"
cp "_temp/SUPER MARIO 64#31B77240#0#2_all$EXT" "$PORT/actors/poundable_pole/poundable_pole_top$EXT"

cp "_temp/SUPER MARIO 64#9F02A40F#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_five_segments$EXT"
cp "_temp/SUPER MARIO 64#10F30B26#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_four_segments$EXT"
cp "_temp/SUPER MARIO 64#F1C23131#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_full$EXT"
cp "_temp/SUPER MARIO 64#FD569CD5#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_left_side$EXT"
cp "_temp/SUPER MARIO 64#076B5C8F#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_one_segment$EXT"
cp "_temp/SUPER MARIO 64#6CA78364#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_right_side$EXT"
cp "_temp/SUPER MARIO 64#4DC0BBDF#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_seven_segments$EXT"
cp "_temp/SUPER MARIO 64#2B846815#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_six_segments$EXT"
cp "_temp/SUPER MARIO 64#268B611D#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_three_segments$EXT"
cp "_temp/SUPER MARIO 64#BCBD0842#0#2_all$EXT" "$PORT/actors/power_meter/power_meter_two_segments$EXT"

cp "_temp/SUPER MARIO 64#CD381281#0#2_all$EXT" "$PORT/actors/purple_switch/purple_switch_base$EXT"
cp "_temp/SUPER MARIO 64#3AC6C19C#0#2_all$EXT" "$PORT/actors/purple_switch/purple_switch_exclamation_point$EXT"

cp "_temp/SUPER MARIO 64#CD2A5787#0#2_all$EXT" "$PORT/actors/sand/sand_particle$EXT"

cp "_temp/SUPER MARIO 64#E6919896#0#2_all$EXT" "$PORT/actors/scuttlebug/scuttlebug_eye$EXT"
cp "_temp/SUPER MARIO 64#822FF6DF#0#2_all$EXT" "$PORT/actors/scuttlebug/scuttlebug_iris$EXT"
cp "_temp/SUPER MARIO 64#349B3BBD#0#2_all$EXT" "$PORT/actors/scuttlebug/scuttlebug_left_side$EXT"
cp "_temp/SUPER MARIO 64#C540C44C#0#2_all$EXT" "$PORT/actors/scuttlebug/scuttlebug_leg$EXT"
cp "_temp/SUPER MARIO 64#55DA5D92#0#2_all$EXT" "$PORT/actors/scuttlebug/scuttlebug_right_side$EXT"

cp "_temp/SUPER MARIO 64#C989266F#0#2_all$EXT" "$PORT/actors/seaweed/seaweed_base$EXT"
cp "_temp/SUPER MARIO 64#20E1EA4D#0#2_all$EXT" "$PORT/actors/seaweed/seaweed_lower_center$EXT"
cp "_temp/SUPER MARIO 64#513BD6B7#0#2_all$EXT" "$PORT/actors/seaweed/seaweed_tip$EXT"
cp "_temp/SUPER MARIO 64#D53A754E#0#2_all$EXT" "$PORT/actors/seaweed/seaweed_upper_center$EXT"

cp "_temp/SUPER MARIO 64#6AC8D5D1#0#2_all$EXT" "$PORT/actors/skeeter/skeeter_eye$EXT"
cp "_temp/SUPER MARIO 64#A6469110#0#2_all$EXT" "$PORT/actors/skeeter/skeeter_iris$EXT"

cp "_temp/SUPER MARIO 64#E48F835F#0#2_all$EXT" "$PORT/actors/snowman/mr_blizzard_eye$EXT"
cp "_temp/SUPER MARIO 64#2395DA7B#0#2_all$EXT" "$PORT/actors/snowman/mr_blizzard_left_side$EXT"
cp "_temp/SUPER MARIO 64#6A4BEF91#0#2_all$EXT" "$PORT/actors/snowman/mr_blizzard_mitten$EXT"
cp "_temp/SUPER MARIO 64#E52EE127#0#2_all$EXT" "$PORT/actors/snowman/mr_blizzard_mouth$EXT"
cp "_temp/SUPER MARIO 64#88C0CCF9#0#2_all$EXT" "$PORT/actors/snowman/mr_blizzard_right_side$EXT"

cp "_temp/SUPER MARIO 64#458C0935#0#2_all$EXT" "$PORT/actors/snufit/snufit_body$EXT"
cp "_temp/SUPER MARIO 64#FACEA23F#0#2_all$EXT" "$PORT/actors/snufit/snufit_eye$EXT"
cp "_temp/SUPER MARIO 64#1F4CDAB4#0#2_all$EXT" "$PORT/actors/snufit/snufit_mask_strap$EXT"
cp "_temp/SUPER MARIO 64#6BCC2E51#0#2_all$EXT" "$PORT/actors/snufit/snufit_mouth$EXT"

cp "_temp/SUPER MARIO 64#F11E411F#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_0$EXT"
cp "_temp/SUPER MARIO 64#906FF62E#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_1$EXT"
cp "_temp/SUPER MARIO 64#57F55B58#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_2$EXT"
cp "_temp/SUPER MARIO 64#8188E2DD#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_3$EXT"
cp "_temp/SUPER MARIO 64#F4FAB5F3#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_4$EXT"
cp "_temp/SUPER MARIO 64#B9C749B9#0#2_all$EXT" "$PORT/actors/sparkle/sparkle_5$EXT"

cp "_temp/SUPER MARIO 64#2465B806#3#2_all$EXT" "$PORT/actors/sparkle_animation/sparkle_animation_0$EXT"
cp "_temp/SUPER MARIO 64#EED115D8#3#2_all$EXT" "$PORT/actors/sparkle_animation/sparkle_animation_1$EXT"
cp "_temp/SUPER MARIO 64#2A283A6A#3#2_all$EXT" "$PORT/actors/sparkle_animation/sparkle_animation_2$EXT"
cp "_temp/SUPER MARIO 64#87805A7C#3#2_all$EXT" "$PORT/actors/sparkle_animation/sparkle_animation_3$EXT"
cp "_temp/SUPER MARIO 64#064F172D#3#2_all$EXT" "$PORT/actors/sparkle_animation/sparkle_animation_4$EXT"

cp "_temp/SUPER MARIO 64#13207BBB#0#2_all$EXT" "$PORT/actors/spindrift/spindrift_face$EXT"
cp "_temp/SUPER MARIO 64#9DC7C1E8#0#2_all$EXT" "$PORT/actors/spindrift/spindrift_head$EXT"
cp "_temp/SUPER MARIO 64#DCD89861#0#2_all$EXT" "$PORT/actors/spindrift/spindrift_leaf$EXT"
cp "_temp/SUPER MARIO 64#0F8EBA38#0#2_all$EXT" "$PORT/actors/spindrift/spindrift_petal$EXT"

cp "_temp/SUPER MARIO 64#10E998F8#0#2_all$EXT" "$PORT/actors/star/star_eye$EXT"

cp "_temp/SUPER MARIO 64#A6411501#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_0$EXT"
cp "_temp/SUPER MARIO 64#D8504EE4#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_1$EXT"
cp "_temp/SUPER MARIO 64#C7B5DBC9#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_2$EXT"
cp "_temp/SUPER MARIO 64#4446F65D#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_3$EXT"
cp "_temp/SUPER MARIO 64#BB48F1BC#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_4$EXT"
cp "_temp/SUPER MARIO 64#9374994C#3#2_all$EXT" "$PORT/actors/stomp_smoke/stomp_smoke_5$EXT"

cp "_temp/SUPER MARIO 64#E127CEDD#0#2_all$EXT" "$PORT/actors/sushi/sushi_eye$EXT"
cp "_temp/SUPER MARIO 64#0010FDC4#0#2_all$EXT" "$PORT/actors/sushi/sushi_snout$EXT"
cp "_temp/SUPER MARIO 64#D4178125#0#2_all$EXT" "$PORT/actors/sushi/sushi_tooth$EXT"

cp "_temp/SUPER MARIO 64#D220AA57#0#2_all$EXT" "$PORT/actors/swoop/swoop_body$EXT"
cp "_temp/SUPER MARIO 64#F399A4E9#0#2_all$EXT" "$PORT/actors/swoop/swoop_eye$EXT"
cp "_temp/SUPER MARIO 64#DF2A6551#0#2_all$EXT" "$PORT/actors/swoop/swoop_nose$EXT"
cp "_temp/SUPER MARIO 64#629A458D#0#2_all$EXT" "$PORT/actors/swoop/swoop_wing$EXT"

cp "_temp/SUPER MARIO 64#17CDE57D#0#2_all$EXT" "$PORT/actors/thwomp/thwomp_face$EXT"
cp "_temp/SUPER MARIO 64#39D86D67#0#2_all$EXT" "$PORT/actors/thwomp/thwomp_surface$EXT"

cp "_temp/SUPER MARIO 64#39F5A629#0#2_all$EXT" "$PORT/actors/toad/toad_face$EXT"
cp "_temp/SUPER MARIO 64#383BBD9B#0#2_all$EXT" "$PORT/actors/toad/toad_head$EXT"

cp "_temp/SUPER MARIO 64#A7BDD88F#3#2_all$EXT" "$PORT/actors/tornado/tornado$EXT"

cp "_temp/SUPER MARIO 64#1B6ACD5E#0#2_all$EXT" "$PORT/actors/treasure_chest/treasure_chest_front$EXT"
cp "_temp/SUPER MARIO 64#E60FFD91#0#2_all$EXT" "$PORT/actors/treasure_chest/treasure_chest_lock$EXT"
cp "_temp/SUPER MARIO 64#87D447AF#0#2_all$EXT" "$PORT/actors/treasure_chest/treasure_chest_lock_top$EXT"
cp "_temp/SUPER MARIO 64#8F698CC1#0#2_all$EXT" "$PORT/actors/treasure_chest/treasure_chest_side$EXT"

cp "_temp/SUPER MARIO 64#7AF18328#0#2_all$EXT" "$PORT/actors/tree/palm_tree$EXT"
cp "_temp/SUPER MARIO 64#C2E48C81#0#2_all$EXT" "$PORT/actors/tree/pine_tree$EXT"
cp "_temp/SUPER MARIO 64#3FB69C59#0#2_all$EXT" "$PORT/actors/tree/snowy_pine_tree$EXT"
cp "_temp/SUPER MARIO 64#192FA726#0#2_all$EXT" "$PORT/actors/tree/tree_left_side$EXT"
cp "_temp/SUPER MARIO 64#B452CBBE#0#2_all$EXT" "$PORT/actors/tree/tree_right_side$EXT"

cp "_temp/SUPER MARIO 64#31C66E6F#0#2_all$EXT" "$PORT/actors/ukiki/ukiki_butt$EXT"
cp "_temp/SUPER MARIO 64#49F74EB1#0#2_all$EXT" "$PORT/actors/ukiki/ukiki_face$EXT"
cp "_temp/SUPER MARIO 64#EA6F033E#0#2_all$EXT" "$PORT/actors/ukiki/ukiki_fur$EXT"

cp "_temp/SUPER MARIO 64#F0729E14#0#2_all$EXT" "$PORT/actors/unagi/unagi_body$EXT"
cp "_temp/SUPER MARIO 64#6D6C38E3#0#2_all$EXT" "$PORT/actors/unagi/unagi_eye$EXT"
cp "_temp/SUPER MARIO 64#59BBF047#0#2_all$EXT" "$PORT/actors/unagi/unagi_head_base$EXT"
cp "_temp/SUPER MARIO 64#DB1CF863#0#2_all$EXT" "$PORT/actors/unagi/unagi_mouth$EXT"
cp "_temp/SUPER MARIO 64#AD35A744#0#2_all$EXT" "$PORT/actors/unagi/unagi_tail$EXT"
cp "_temp/SUPER MARIO 64#EDBBE3D1#0#2_all$EXT" "$PORT/actors/unagi/unagi_tooth$EXT"

cp "_temp/SUPER MARIO 64#8A94D5A3#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_0$EXT"
cp "_temp/SUPER MARIO 64#BBD69D4A#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_1$EXT"
cp "_temp/SUPER MARIO 64#92828A2B#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_2$EXT"
cp "_temp/SUPER MARIO 64#3CB6F1A9#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_3$EXT"
cp "_temp/SUPER MARIO 64#9C50AF6D#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_4$EXT"
cp "_temp/SUPER MARIO 64#1A43DF6A#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_5$EXT"
cp "_temp/SUPER MARIO 64#84836B2D#3#2_all$EXT" "$PORT/actors/walk_smoke/walk_smoke_6$EXT"

cp "_temp/SUPER MARIO 64#E9CABB44#0#2_all$EXT" "$PORT/actors/warp_pipe/warp_pipe_side$EXT"
cp "_temp/SUPER MARIO 64#67A98771#0#2_all$EXT" "$PORT/actors/warp_pipe/warp_pipe_top$EXT"

cp "_temp/SUPER MARIO 64#14C95BA0#0#2_all$EXT" "$PORT/actors/water_bubble/water_bubble$EXT"

cp "_temp/SUPER MARIO 64#C82A46F3#0#2_all$EXT" "$PORT/actors/water_mine/water_mine_left_side_unused$EXT"
cp "_temp/SUPER MARIO 64#C2050F68#0#2_all$EXT" "$PORT/actors/water_mine/water_mine_right_side_unused$EXT"
cp "_temp/SUPER MARIO 64#AE1D5DC1#0#2_all$EXT" "$PORT/actors/water_mine/water_mine_spike_unused$EXT"

cp "_temp/SUPER MARIO 64#53C1213E#0#2_all$EXT" "$PORT/actors/water_ring/water_ring$EXT"

cp "_temp/SUPER MARIO 64#FA11921A#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_0$EXT"
cp "_temp/SUPER MARIO 64#444B37F6#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_1$EXT"
cp "_temp/SUPER MARIO 64#674FA5C8#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_2$EXT"
cp "_temp/SUPER MARIO 64#928D4E78#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_3$EXT"
cp "_temp/SUPER MARIO 64#E04DCB5D#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_4$EXT"
cp "_temp/SUPER MARIO 64#B54D1A02#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_5$EXT"
cp "_temp/SUPER MARIO 64#4844CCB0#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_6$EXT"
cp "_temp/SUPER MARIO 64#0F5D756E#0#2_all$EXT" "$PORT/actors/water_splash/water_splash_7$EXT"

cp "_temp/SUPER MARIO 64#FBA28E17#3#2_all$EXT" "$PORT/actors/water_wave/water_wave_0$EXT"
cp "_temp/SUPER MARIO 64#4B0C0C56#3#2_all$EXT" "$PORT/actors/water_wave/water_wave_1$EXT"
cp "_temp/SUPER MARIO 64#5FF8D3EF#3#2_all$EXT" "$PORT/actors/water_wave/water_wave_2$EXT"
cp "_temp/SUPER MARIO 64#67D8B446#3#2_all$EXT" "$PORT/actors/water_wave/water_wave_3$EXT"

cp "_temp/SUPER MARIO 64#A7BDD88F#3#2_all$EXT" "$PORT/actors/whirlpool/whirlpool$EXT"

cp "_temp/SUPER MARIO 64#5B8676CF#0#2_all$EXT" "$PORT/actors/white_particle/snow_particle$EXT"

cp "_temp/SUPER MARIO 64#54FAC607#0#2_all$EXT" "$PORT/actors/white_particle_small/small_snow_particle$EXT"

cp "_temp/SUPER MARIO 64#D42E66E7#0#2_all$EXT" "$PORT/actors/whomp/whomp_back$EXT"
cp "_temp/SUPER MARIO 64#6695E997#0#2_all$EXT" "$PORT/actors/whomp/whomp_face$EXT"
cp "_temp/SUPER MARIO 64#4DEDBC41#0#2_all$EXT" "$PORT/actors/whomp/whomp_hand$EXT"
cp "_temp/SUPER MARIO 64#8464CC0C#0#2_all$EXT" "$PORT/actors/whomp/whomp_surface$EXT"

cp "_temp/SUPER MARIO 64#10E998F8#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_eye$EXT"
cp "_temp/SUPER MARIO 64#0E9C4E15#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_flower$EXT"
cp "_temp/SUPER MARIO 64#52FEDEB7#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_frown$EXT"
cp "_temp/SUPER MARIO 64#4E43931B#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_nose_left_side$EXT"
cp "_temp/SUPER MARIO 64#A2F30414#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_nose_right_side$EXT"
cp "_temp/SUPER MARIO 64#3867CBEE#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_segment_left_side$EXT"
cp "_temp/SUPER MARIO 64#3411743E#0#2_all$EXT" "$PORT/actors/wiggler/wiggler_segment_right_side$EXT"

cp "_temp/SUPER MARIO 64#F09D711E#0#2_all$EXT" "$PORT/actors/wooden_signpost/wooden_signpost_back$EXT"
cp "_temp/SUPER MARIO 64#125E068D#0#2_all$EXT" "$PORT/actors/wooden_signpost/wooden_signpost_front$EXT"

cp "_temp/SUPER MARIO 64#8E41FFCD#0#2_all$EXT" "$PORT/actors/yellow_sphere/yellow_sphere$EXT"
cp "_temp/SUPER MARIO 64#8E41FFCD#0#2_all$EXT" "$PORT/actors/yellow_sphere_small/small_yellow_sphere$EXT"

cp "_temp/SUPER MARIO 64#506D1A26#0#2_all$EXT" "$PORT/actors/yoshi/yoshi_eye$EXT"
cp "_temp/SUPER MARIO 64#0AB43F69#0#2_all$EXT" "$PORT/actors/yoshi/yoshi_eye_blink$EXT"
cp "_temp/SUPER MARIO 64#17060726#0#2_all$EXT" "$PORT/actors/yoshi/yoshi_nostril$EXT"

cp "_temp/SUPER MARIO 64#E559FC96#0#2_all$EXT" "$PORT/levels/bbh/0$EXT"
cp "_temp/SUPER MARIO 64#24767D89#0#2_all$EXT" "$PORT/levels/bbh/1$EXT"
cp "_temp/SUPER MARIO 64#222768FA#0#2_all$EXT" "$PORT/levels/bbh/2$EXT"
cp "_temp/SUPER MARIO 64#381EA750#0#2_all$EXT" "$PORT/levels/bbh/3$EXT"
cp "_temp/SUPER MARIO 64#0C8C45BA#0#2_all$EXT" "$PORT/levels/bbh/4$EXT"
cp "_temp/SUPER MARIO 64#17405808#0#2_all$EXT" "$PORT/levels/bbh/5$EXT"
cp "_temp/SUPER MARIO 64#D950DA92#0#2_all$EXT" "$PORT/levels/bbh/6$EXT"

cp "_temp/SUPER MARIO 64#54670BB6#0#2_all$EXT" "$PORT/levels/bitdw/0$EXT"
cp "_temp/SUPER MARIO 64#59C3CDD9#0#2_all$EXT" "$PORT/levels/bitdw/1$EXT"
cp "_temp/SUPER MARIO 64#13132153#0#2_all$EXT" "$PORT/levels/bitdw/2$EXT"
cp "_temp/SUPER MARIO 64#177D197C#0#2_all$EXT" "$PORT/levels/bitdw/3$EXT"

cp "_temp/SUPER MARIO 64#A7C43AFC#0#2_all$EXT" "$PORT/levels/bitfs/0$EXT"
cp "_temp/SUPER MARIO 64#91252367#0#2_all$EXT" "$PORT/levels/bitfs/1$EXT"
cp "_temp/SUPER MARIO 64#8E28628B#0#2_all$EXT" "$PORT/levels/bitfs/2$EXT"

cp "_temp/SUPER MARIO 64#6069E288#0#2_all$EXT" "$PORT/levels/bits/0$EXT"
cp "_temp/SUPER MARIO 64#A290798B#0#2_all$EXT" "$PORT/levels/bits/1$EXT"
cp "_temp/SUPER MARIO 64#B0CD69EF#0#2_all$EXT" "$PORT/levels/bits/2$EXT"

cp "_temp/SUPER MARIO 64#CBE026C4#0#2_all$EXT" "$PORT/levels/bob/0$EXT"
cp "_temp/SUPER MARIO 64#0DDBBC70#0#2_all$EXT" "$PORT/levels/bob/1$EXT"
cp "_temp/SUPER MARIO 64#245EA00F#0#2_all$EXT" "$PORT/levels/bob/2$EXT"
cp "_temp/SUPER MARIO 64#A2D48F6C#0#2_all$EXT" "$PORT/levels/bob/3$EXT"
cp "_temp/SUPER MARIO 64#AE019762#0#2_all$EXT" "$PORT/levels/bob/4$EXT"

cp "_temp/SUPER MARIO 64#B017CFF7#0#2_all$EXT" "$PORT/levels/bowser_1/0$EXT"
cp "_temp/SUPER MARIO 64#60351310#0#2_all$EXT" "$PORT/levels/bowser_1/1$EXT"
cp "_temp/SUPER MARIO 64#CA7E41B1#0#2_all$EXT" "$PORT/levels/bowser_1/2$EXT"

cp "_temp/SUPER MARIO 64#6D8CFA2F#0#2_all$EXT" "$PORT/levels/bowser_2/0$EXT"

cp "_temp/SUPER MARIO 64#61C24B5E#0#2_all$EXT" "$PORT/levels/bowser_3/0$EXT"
cp "_temp/SUPER MARIO 64#DF5317B2#0#2_all$EXT" "$PORT/levels/bowser_3/1$EXT"
cp "_temp/SUPER MARIO 64#204D81E4#0#2_all$EXT" "$PORT/levels/bowser_3/2$EXT"

cp "_temp/SUPER MARIO 64#146F813F#0#2_all$EXT" "$PORT/levels/castle_grounds/0$EXT"
cp "_temp/SUPER MARIO 64#0FDD80CA#0#2_all$EXT" "$PORT/levels/castle_grounds/1$EXT"
cp "_temp/SUPER MARIO 64#0D09F13E#0#2_all$EXT" "$PORT/levels/castle_grounds/2$EXT"
cp "_temp/SUPER MARIO 64#064B5C5F#0#2_all$EXT" "$PORT/levels/castle_grounds/3$EXT"
cp "_temp/SUPER MARIO 64#C4845A3E#0#2_all$EXT" "$PORT/levels/castle_grounds/4$EXT"
cp "_temp/SUPER MARIO 64#AC05A9FF#3#1_all$EXT" "$PORT/levels/castle_grounds/5$EXT"

cp "_temp/SUPER MARIO 64#54F2C81A#0#2_all$EXT" "$PORT/levels/castle_inside/1$EXT"
cp "_temp/SUPER MARIO 64#2EB2480C#3#2_all$EXT" "$PORT/levels/castle_inside/2$EXT"
cp "_temp/SUPER MARIO 64#2DC59B5C#0#2_all$EXT" "$PORT/levels/castle_inside/3$EXT"
cp "_temp/SUPER MARIO 64#8EE5398C#0#2_all$EXT" "$PORT/levels/castle_inside/4$EXT"
cp "_temp/SUPER MARIO 64#F2897E05#0#2_all$EXT" "$PORT/levels/castle_inside/5$EXT"
cp "_temp/SUPER MARIO 64#1EBAE88A#0#2_all$EXT" "$PORT/levels/castle_inside/6$EXT"
cp "_temp/SUPER MARIO 64#CC25CE0F#0#2_all$EXT" "$PORT/levels/castle_inside/7$EXT"
cp "_temp/SUPER MARIO 64#73D7C121#0#2_all$EXT" "$PORT/levels/castle_inside/8$EXT"
cp "_temp/SUPER MARIO 64#CB7B6E97#0#2_all$EXT" "$PORT/levels/castle_inside/9$EXT"
cp "_temp/SUPER MARIO 64#678BBBC1#0#2_all$EXT" "$PORT/levels/castle_inside/10$EXT"
cp "_temp/SUPER MARIO 64#A08E284C#0#2_all$EXT" "$PORT/levels/castle_inside/11$EXT"
cp "_temp/SUPER MARIO 64#1C786EE9#0#2_all$EXT" "$PORT/levels/castle_inside/12$EXT"
cp "_temp/SUPER MARIO 64#8D030865#0#2_all$EXT" "$PORT/levels/castle_inside/13$EXT"
cp "_temp/SUPER MARIO 64#EB871023#0#2_all$EXT" "$PORT/levels/castle_inside/14$EXT"
cp "_temp/SUPER MARIO 64#B1237167#0#2_all$EXT" "$PORT/levels/castle_inside/15$EXT"
cp "_temp/SUPER MARIO 64#FC4B4762#0#2_all$EXT" "$PORT/levels/castle_inside/17$EXT"
cp "_temp/SUPER MARIO 64#946E561B#0#2_all$EXT" "$PORT/levels/castle_inside/18$EXT"
cp "_temp/SUPER MARIO 64#B5AC8928#0#2_all$EXT" "$PORT/levels/castle_inside/19$EXT"
cp "_temp/SUPER MARIO 64#95C4562E#0#2_all$EXT" "$PORT/levels/castle_inside/20$EXT"
cp "_temp/SUPER MARIO 64#88493238#0#2_all$EXT" "$PORT/levels/castle_inside/21$EXT"
cp "_temp/SUPER MARIO 64#90EF51BB#0#2_all$EXT" "$PORT/levels/castle_inside/22$EXT"
cp "_temp/SUPER MARIO 64#08B8530E#0#2_all$EXT" "$PORT/levels/castle_inside/23$EXT"
cp "_temp/SUPER MARIO 64#1A4BCC77#0#2_all$EXT" "$PORT/levels/castle_inside/24$EXT"
cp "_temp/SUPER MARIO 64#8300DD14#0#2_all$EXT" "$PORT/levels/castle_inside/25$EXT"
cp "_temp/SUPER MARIO 64#A8FF4543#0#2_all$EXT" "$PORT/levels/castle_inside/26$EXT"
cp "_temp/SUPER MARIO 64#CCA2987C#0#2_all$EXT" "$PORT/levels/castle_inside/27$EXT"
cp "_temp/SUPER MARIO 64#D2A1C338#0#2_all$EXT" "$PORT/levels/castle_inside/28$EXT"
cp "_temp/SUPER MARIO 64#184368CA#0#2_all$EXT" "$PORT/levels/castle_inside/29$EXT"
cp "_temp/SUPER MARIO 64#27183C4F#0#2_all$EXT" "$PORT/levels/castle_inside/30$EXT"
cp "_temp/SUPER MARIO 64#E8FABCC5#0#2_all$EXT" "$PORT/levels/castle_inside/31$EXT"
cp "_temp/SUPER MARIO 64#B6A89482#0#2_all$EXT" "$PORT/levels/castle_inside/32$EXT"
cp "_temp/SUPER MARIO 64#8B6C6929#0#2_all$EXT" "$PORT/levels/castle_inside/33$EXT"
cp "_temp/SUPER MARIO 64#DEAE047B#0#2_all$EXT" "$PORT/levels/castle_inside/34$EXT"
cp "_temp/SUPER MARIO 64#603AB9FE#0#2_all$EXT" "$PORT/levels/castle_inside/35$EXT"
cp "_temp/SUPER MARIO 64#FE391DDB#0#2_all$EXT" "$PORT/levels/castle_inside/36$EXT"
cp "_temp/SUPER MARIO 64#981FC4C1#0#2_all$EXT" "$PORT/levels/castle_inside/37$EXT"
cp "_temp/SUPER MARIO 64#239F9E44#0#2_all$EXT" "$PORT/levels/castle_inside/38$EXT"
cp "_temp/SUPER MARIO 64#6FF2AAC5#0#2_all$EXT" "$PORT/levels/castle_inside/39$EXT"
cp "_temp/SUPER MARIO 64#33AE70AA#0#2_all$EXT" "$PORT/levels/castle_inside/40$EXT"
cp "_temp/SUPER MARIO 64#65542036#3#2_all$EXT" "$PORT/levels/castle_inside/castle_light$EXT"

cp "_temp/SUPER MARIO 64#611B82B3#0#2_all$EXT" "$PORT/levels/ccm/0$EXT"
cp "_temp/SUPER MARIO 64#15686BED#0#2_all$EXT" "$PORT/levels/ccm/1$EXT"
cp "_temp/SUPER MARIO 64#266A1564#0#2_all$EXT" "$PORT/levels/ccm/2$EXT"
cp "_temp/SUPER MARIO 64#B2718DB8#0#2_all$EXT" "$PORT/levels/ccm/3$EXT"
cp "_temp/SUPER MARIO 64#8299C450#0#2_all$EXT" "$PORT/levels/ccm/4$EXT"
cp "_temp/SUPER MARIO 64#E52EE127#0#2_all$EXT" "$PORT/levels/ccm/5$EXT"
cp "_temp/SUPER MARIO 64#E48F835F#0#2_all$EXT" "$PORT/levels/ccm/6$EXT"
cp "_temp/SUPER MARIO 64#4276DB5E#0#2_all$EXT" "$PORT/levels/ccm/7$EXT"
cp "_temp/SUPER MARIO 64#3BAC2B9A#3#2_all$EXT" "$PORT/levels/ccm/8$EXT"
cp "_temp/SUPER MARIO 64#FE55B4F9#3#2_all$EXT" "$PORT/levels/ccm/9$EXT"
cp "_temp/SUPER MARIO 64#D83419B2#0#2_all$EXT" "$PORT/levels/ccm/10$EXT"
cp "_temp/SUPER MARIO 64#3FF93DA3#0#2_all$EXT" "$PORT/levels/ccm/11$EXT"
cp "_temp/SUPER MARIO 64#9D15E307#0#2_all$EXT" "$PORT/levels/ccm/12$EXT"

cp "_temp/SUPER MARIO 64#A22A5A73#0#2_all$EXT" "$PORT/levels/cotmc/0$EXT"
cp "_temp/SUPER MARIO 64#A055E62E#0#2_all$EXT" "$PORT/levels/cotmc/1$EXT"
cp "_temp/SUPER MARIO 64#F22E4881#0#2_all$EXT" "$PORT/levels/cotmc/3$EXT"
cp "_temp/SUPER MARIO 64#5AC90B8D#0#2_all$EXT" "$PORT/levels/cotmc/4$EXT"

cp "_temp/SUPER MARIO 64#F6C53A3C#0#2_all$EXT" "$PORT/levels/ddd/0$EXT"
cp "_temp/SUPER MARIO 64#6A925357#0#2_all$EXT" "$PORT/levels/ddd/1$EXT"
cp "_temp/SUPER MARIO 64#164FBE11#0#2_all$EXT" "$PORT/levels/ddd/2$EXT"
cp "_temp/SUPER MARIO 64#7B8E447D#0#2_all$EXT" "$PORT/levels/ddd/3$EXT"
cp "_temp/SUPER MARIO 64#1D6FCB73#0#2_all$EXT" "$PORT/levels/ddd/4$EXT"

cp "_temp/SUPER MARIO 64#FE1AB8D0#0#2_all$EXT" "$PORT/levels/hmc/0$EXT"
cp "_temp/SUPER MARIO 64#65BFA19A#0#2_all$EXT" "$PORT/levels/hmc/1$EXT"
cp "_temp/SUPER MARIO 64#829B7107#0#2_all$EXT" "$PORT/levels/hmc/2$EXT"
cp "_temp/SUPER MARIO 64#06682E2E#0#2_all$EXT" "$PORT/levels/hmc/3$EXT"
cp "_temp/SUPER MARIO 64#6BEFEDB8#0#2_all$EXT" "$PORT/levels/hmc/4$EXT"
cp "_temp/SUPER MARIO 64#8D2F37B0#0#2_all$EXT" "$PORT/levels/hmc/5$EXT"
cp "_temp/SUPER MARIO 64#4ED23BE0#0#2_all$EXT" "$PORT/levels/hmc/6$EXT"
cp "_temp/SUPER MARIO 64#184368CA#0#2_all$EXT" "$PORT/levels/hmc/7$EXT"

cp "_temp/SUPER MARIO 64#3BA40EE9#0#2_all$EXT" "$PORT/levels/intro/0$EXT"
cp "_temp/SUPER MARIO 64#B7C38322#0#2_all$EXT" "$PORT/levels/intro/1$EXT"
cp "_temp/SUPER MARIO 64#610B81D3#0#2_all$EXT" "$PORT/levels/intro/2_copyright$EXT"
cp "_temp/SUPER MARIO 64#3D51E423#0#2_all$EXT" "$PORT/levels/intro/3_tm$EXT"

cp "_temp/SUPER MARIO 64#6A925357#0#2_all$EXT" "$PORT/levels/jrb/0$EXT"
cp "_temp/SUPER MARIO 64#C5E87355#0#2_all$EXT" "$PORT/levels/jrb/1$EXT"
cp "_temp/SUPER MARIO 64#4010BAE8#0#2_all$EXT" "$PORT/levels/jrb/2$EXT"
cp "_temp/SUPER MARIO 64#49997119#0#2_all$EXT" "$PORT/levels/jrb/3$EXT"

cp "_temp/SUPER MARIO 64#2A83D55A#0#2_all$EXT" "$PORT/levels/lll/0$EXT"
cp "_temp/SUPER MARIO 64#D494EB3B#0#2_all$EXT" "$PORT/levels/lll/1$EXT"
cp "_temp/SUPER MARIO 64#0B962372#0#2_all$EXT" "$PORT/levels/lll/2$EXT"
cp "_temp/SUPER MARIO 64#E3F0759B#0#2_all$EXT" "$PORT/levels/lll/3$EXT"
cp "_temp/SUPER MARIO 64#C0BCCCF4#0#2_all$EXT" "$PORT/levels/lll/4$EXT"
cp "_temp/SUPER MARIO 64#945943B1#0#2_all$EXT" "$PORT/levels/lll/5$EXT"
cp "_temp/SUPER MARIO 64#1ECB06AF#0#2_all$EXT" "$PORT/levels/lll/6$EXT"
cp "_temp/SUPER MARIO 64#5996660E#0#2_all$EXT" "$PORT/levels/lll/7$EXT"
cp "_temp/SUPER MARIO 64#F4D429FD#0#2_all$EXT" "$PORT/levels/lll/8$EXT"
cp "_temp/SUPER MARIO 64#508E888F#0#2_all$EXT" "$PORT/levels/lll/9$EXT"
cp "_temp/SUPER MARIO 64#3A9A3561#0#2_all$EXT" "$PORT/levels/lll/10$EXT"
cp "_temp/SUPER MARIO 64#E42D6AA8#0#2_all$EXT" "$PORT/levels/lll/11$EXT"
cp "_temp/SUPER MARIO 64#46A556F1#0#2_all$EXT" "$PORT/levels/lll/12$EXT"
cp "_temp/SUPER MARIO 64#7323E612#0#2_all$EXT" "$PORT/levels/lll/13$EXT"
cp "_temp/SUPER MARIO 64#4A750285#0#2_all$EXT" "$PORT/levels/lll/14$EXT"
cp "_temp/SUPER MARIO 64#6541DD48#0#2_all$EXT" "$PORT/levels/lll/15$EXT"
cp "_temp/SUPER MARIO 64#4E0A3338#0#2_all$EXT" "$PORT/levels/lll/16$EXT"
cp "_temp/SUPER MARIO 64#A804C734#0#2_all$EXT" "$PORT/levels/lll/17$EXT"
cp "_temp/SUPER MARIO 64#D9E8F2F0#0#2_all$EXT" "$PORT/levels/lll/18$EXT"
cp "_temp/SUPER MARIO 64#F6AFFEC8#0#2_all$EXT" "$PORT/levels/lll/19$EXT"
cp "_temp/SUPER MARIO 64#CCFDAE7D#0#2_all$EXT" "$PORT/levels/lll/20$EXT"
cp "_temp/SUPER MARIO 64#BBCA6538#0#2_all$EXT" "$PORT/levels/lll/21$EXT"
cp "_temp/SUPER MARIO 64#F71BCBCA#0#2_all$EXT" "$PORT/levels/lll/22$EXT"
cp "_temp/SUPER MARIO 64#EA11FB10#0#2_all$EXT" "$PORT/levels/lll/23$EXT"
cp "_temp/SUPER MARIO 64#36FC4C04#0#2_all$EXT" "$PORT/levels/lll/24$EXT"
cp "_temp/SUPER MARIO 64#C64AD046#0#2_all$EXT" "$PORT/levels/lll/25$EXT"
cp "_temp/SUPER MARIO 64#63F6E568#0#2_all$EXT" "$PORT/levels/lll/26$EXT"
cp "_temp/SUPER MARIO 64#3BAC2B9A#3#2_all$EXT" "$PORT/levels/lll/27$EXT"
cp "_temp/SUPER MARIO 64#7AE8E843#0#2_all$EXT" "$PORT/levels/lll/28$EXT"
cp "_temp/SUPER MARIO 64#144C8CF3#0#2_all$EXT" "$PORT/levels/lll/29$EXT"
cp "_temp/SUPER MARIO 64#1541A06E#0#2_all$EXT" "$PORT/levels/lll/30$EXT"
cp "_temp/SUPER MARIO 64#6A748651#0#2_all$EXT" "$PORT/levels/lll/31$EXT"
cp "_temp/SUPER MARIO 64#8F25C650#0#2_all$EXT" "$PORT/levels/lll/32$EXT"

cp "_temp/SUPER MARIO 64#EBE128AA#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.0A1D0$EXT"
cp "_temp/SUPER MARIO 64#D135687E#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.0D1A8$EXT"
cp "_temp/SUPER MARIO 64#FAD8C6E1#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.0E1A8$EXT"
cp "_temp/SUPER MARIO 64#474F8A1B#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.00018$EXT"
cp "_temp/SUPER MARIO 64#3C99819F#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.00818$EXT"
cp "_temp/SUPER MARIO 64#FAE4A688#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.01018$EXT"
cp "_temp/SUPER MARIO 64#A34F223C#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.02018$EXT"
cp "_temp/SUPER MARIO 64#431E1944#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.03C68$EXT"
cp "_temp/SUPER MARIO 64#EC60ED0C#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.03468$EXT"
cp "_temp/SUPER MARIO 64#FBCB7598#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.04C68$EXT"
cp "_temp/SUPER MARIO 64#E5D87CD6#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.04468$EXT"
cp "_temp/SUPER MARIO 64#72CB8C7F#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.05468$EXT"
cp "_temp/SUPER MARIO 64#1056B1F2#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.06B28$EXT"
cp "_temp/SUPER MARIO 64#66799DCC#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.06328$EXT"
cp "_temp/SUPER MARIO 64#5F21CD0B#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.07BD0$EXT"
cp "_temp/SUPER MARIO 64#0075DA18#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.07DD0$EXT"
cp "_temp/SUPER MARIO 64#1CDCC29C#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.07FD0$EXT"
cp "_temp/SUPER MARIO 64#BE7558ED#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.073D0$EXT"
cp "_temp/SUPER MARIO 64#6379BE10#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.075D0$EXT"
cp "_temp/SUPER MARIO 64#448CB3E7#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.077D0$EXT"
cp "_temp/SUPER MARIO 64#83CB5976#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.079D0$EXT"
cp "_temp/SUPER MARIO 64#F7DE7C20#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.08BD0$EXT"
cp "_temp/SUPER MARIO 64#73017371#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.08DD0$EXT"
cp "_temp/SUPER MARIO 64#4DA5EB87#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.08FD0$EXT"
cp "_temp/SUPER MARIO 64#27AE0809#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.081D0$EXT"
cp "_temp/SUPER MARIO 64#F30400D5#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.083D0$EXT"
cp "_temp/SUPER MARIO 64#9B6626FE#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.085D0$EXT"
cp "_temp/SUPER MARIO 64#52797C8E#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.087D0$EXT"
cp "_temp/SUPER MARIO 64#72C132CB#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.089D0$EXT"
cp "_temp/SUPER MARIO 64#6A94B667#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.09BD0$EXT"
cp "_temp/SUPER MARIO 64#9255AA67#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.09DD0$EXT"
cp "_temp/SUPER MARIO 64#48FC50A9#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.09FD0$EXT"
cp "_temp/SUPER MARIO 64#127B0F41#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.091D0$EXT"
cp "_temp/SUPER MARIO 64#DDAFBC28#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.093D0$EXT"
cp "_temp/SUPER MARIO 64#93E5A95E#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.095D0$EXT"
cp "_temp/SUPER MARIO 64#3711D2C0#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.097D0$EXT"
cp "_temp/SUPER MARIO 64#1CD30ACE#0#2_all$EXT" "$PORT/levels/menu/main_menu_seg7.099D0$EXT"
cp "_temp/SUPER MARIO 64#8A748466#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AC40$EXT"
cp "_temp/SUPER MARIO 64#82868870#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AC80$EXT"
cp "_temp/SUPER MARIO 64#44789E8C#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0ACC0$EXT"
cp "_temp/SUPER MARIO 64#6C889C54#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AD00$EXT"
cp "_temp/SUPER MARIO 64#527E926C#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AD40$EXT"
cp "_temp/SUPER MARIO 64#7A96785C#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AD80$EXT"
cp "_temp/SUPER MARIO 64#7A86845C#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0ADC0$EXT"
cp "_temp/SUPER MARIO 64#66729882#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AE00$EXT"
cp "_temp/SUPER MARIO 64#688C825C#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AE40$EXT"
cp "_temp/SUPER MARIO 64#72768866#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AE80$EXT"
cp "_temp/SUPER MARIO 64#5A807466#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AEC0$EXT"
cp "_temp/SUPER MARIO 64#767C6068#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AF00$EXT"
cp "_temp/SUPER MARIO 64#78986182#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AF40$EXT"
cp "_temp/SUPER MARIO 64#786B7070#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AF80$EXT"
cp "_temp/SUPER MARIO 64#88788776#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0AFC0$EXT"
cp "_temp/SUPER MARIO 64#84788778#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B000$EXT"
cp "_temp/SUPER MARIO 64#68886576#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B040$EXT"
cp "_temp/SUPER MARIO 64#846A6656#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B080$EXT"
cp "_temp/SUPER MARIO 64#788C8286#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B0C0$EXT"
cp "_temp/SUPER MARIO 64#80707E74#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B100$EXT"
cp "_temp/SUPER MARIO 64#84806080#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B140$EXT"
cp "_temp/SUPER MARIO 64#8886887E#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B180$EXT"
cp "_temp/SUPER MARIO 64#A65A6E86#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B1C0$EXT"
cp "_temp/SUPER MARIO 64#964A7E66#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B200$EXT"
cp "_temp/SUPER MARIO 64#68886272#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B240$EXT"
cp "_temp/SUPER MARIO 64#5A967A74#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B280$EXT"
cp "_temp/SUPER MARIO 64#56886274#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B2C0$EXT"
cp "_temp/SUPER MARIO 64#4C947C72#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B300$EXT"
cp "_temp/SUPER MARIO 64#729C6184#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B340$EXT"
cp "_temp/SUPER MARIO 64#8C748686#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B380$EXT"
cp "_temp/SUPER MARIO 64#8A6A5E6E#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B3C0$EXT"
cp "_temp/SUPER MARIO 64#92766B78#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B400$EXT"
cp "_temp/SUPER MARIO 64#945C9872#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B440$EXT"
cp "_temp/SUPER MARIO 64#646A9C64#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B480$EXT"
cp "_temp/SUPER MARIO 64#9A6D7782#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B4C0$EXT"
cp "_temp/SUPER MARIO 64#7C9E686E#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B500$EXT"
cp "_temp/SUPER MARIO 64#686C9480#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B540$EXT"
cp "_temp/SUPER MARIO 64#4C8A74AC#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B580$EXT"
cp "_temp/SUPER MARIO 64#76406E6E#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B5C0$EXT"
cp "_temp/SUPER MARIO 64#82888684#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B600$EXT"
cp "_temp/SUPER MARIO 64#86868886#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B640$EXT"
cp "_temp/SUPER MARIO 64#88898880#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B680$EXT"
cp "_temp/SUPER MARIO 64#80788486#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B6C0$EXT"
cp "_temp/SUPER MARIO 64#607A828A#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B700$EXT"
cp "_temp/SUPER MARIO 64#C4F693E5#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B740$EXT"
cp "_temp/SUPER MARIO 64#7E87867A#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B780$EXT"
cp "_temp/SUPER MARIO 64#8C868486#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B7C0$EXT"
cp "_temp/SUPER MARIO 64#6EB46458#3#1_all$EXT" "$PORT/levels/menu/main_menu_seg7.0B800$EXT"

cp "_temp/SUPER MARIO 64#403C6122#0#2_all$EXT" "$PORT/levels/pss/0$EXT"
cp "_temp/SUPER MARIO 64#19E8F076#3#2_all$EXT" "$PORT/levels/pss/1$EXT"
cp "_temp/SUPER MARIO 64#D795FE9F#0#2_all$EXT" "$PORT/levels/pss/2$EXT"

cp "_temp/SUPER MARIO 64#32169E73#0#2_all$EXT" "$PORT/levels/rr/1$EXT"
cp "_temp/SUPER MARIO 64#4676F47D#0#2_all$EXT" "$PORT/levels/rr/2$EXT"
cp "_temp/SUPER MARIO 64#83101FA2#0#2_all$EXT" "$PORT/levels/rr/quarter_flying_carpet$EXT"

cp "_temp/SUPER MARIO 64#783B816B#0#2_all$EXT" "$PORT/levels/sl/0$EXT"
cp "_temp/SUPER MARIO 64#6CF04010#0#2_all$EXT" "$PORT/levels/sl/1$EXT"
cp "_temp/SUPER MARIO 64#84FED0D8#0#2_all$EXT" "$PORT/levels/sl/2$EXT"
cp "_temp/SUPER MARIO 64#DA375BA5#0#2_all$EXT" "$PORT/levels/sl/3$EXT"
cp "_temp/SUPER MARIO 64#1FC70576#0#2_all$EXT" "$PORT/levels/sl/4$EXT"

cp "_temp/SUPER MARIO 64#8B50E442#0#2_all$EXT" "$PORT/levels/ssl/0$EXT"
cp "_temp/SUPER MARIO 64#1F6DA0F2#3#2_all$EXT" "$PORT/levels/ssl/1$EXT"
cp "_temp/SUPER MARIO 64#5AF9DFDE#0#2_all$EXT" "$PORT/levels/ssl/2$EXT"
cp "_temp/SUPER MARIO 64#85204772#0#2_all$EXT" "$PORT/levels/ssl/3$EXT"
cp "_temp/SUPER MARIO 64#B99A9F71#0#2_all$EXT" "$PORT/levels/ssl/4$EXT"
cp "_temp/SUPER MARIO 64#2E1EB8AA#0#2_all$EXT" "$PORT/levels/ssl/5$EXT"
cp "_temp/SUPER MARIO 64#38AFCCEE#0#2_all$EXT" "$PORT/levels/ssl/6$EXT"
cp "_temp/SUPER MARIO 64#A3DA7F18#0#2_all$EXT" "$PORT/levels/ssl/7$EXT"
cp "_temp/SUPER MARIO 64#325A3830#0#2_all$EXT" "$PORT/levels/ssl/8$EXT"
cp "_temp/SUPER MARIO 64#D5B932A2#0#2_all$EXT" "$PORT/levels/ssl/9$EXT"
cp "_temp/SUPER MARIO 64#ECE06C79#0#2_all$EXT" "$PORT/levels/ssl/10$EXT"
cp "_temp/SUPER MARIO 64#1CB6E388#0#2_all$EXT" "$PORT/levels/ssl/11$EXT"

cp "_temp/SUPER MARIO 64#EB37A9B8#0#2_all$EXT" "$PORT/levels/thi/0$EXT"
cp "_temp/SUPER MARIO 64#D91DA963#0#2_all$EXT" "$PORT/levels/thi/1$EXT"

cp "_temp/SUPER MARIO 64#20167DE7#0#2_all$EXT" "$PORT/levels/totwc/0$EXT"
cp "_temp/SUPER MARIO 64#2B08F032#0#2_all$EXT" "$PORT/levels/totwc/1$EXT"
cp "_temp/SUPER MARIO 64#3163AA92#0#2_all$EXT" "$PORT/levels/totwc/2$EXT"
cp "_temp/SUPER MARIO 64#A7C0A6EB#3#2_all$EXT" "$PORT/levels/totwc/3$EXT"

cp "_temp/SUPER MARIO 64#39E470DD#0#2_all$EXT" "$PORT/levels/ttc/0$EXT"
cp "_temp/SUPER MARIO 64#41304ACC#0#2_all$EXT" "$PORT/levels/ttc/1$EXT"
cp "_temp/SUPER MARIO 64#1C3B41CF#0#2_all$EXT" "$PORT/levels/ttc/2$EXT"

cp "_temp/SUPER MARIO 64#1660C971#3#2_all$EXT" "$PORT/levels/ttm/0$EXT"
cp "_temp/SUPER MARIO 64#51762E4C#0#2_all$EXT" "$PORT/levels/ttm/1$EXT"
cp "_temp/SUPER MARIO 64#D41593D8#0#2_all$EXT" "$PORT/levels/ttm/2$EXT"
cp "_temp/SUPER MARIO 64#B401E19F#0#2_all$EXT" "$PORT/levels/ttm/3$EXT"
cp "_temp/SUPER MARIO 64#B59D468A#0#2_all$EXT" "$PORT/levels/ttm/4$EXT"
cp "_temp/SUPER MARIO 64#28061018#0#2_all$EXT" "$PORT/levels/ttm/5$EXT"
cp "_temp/SUPER MARIO 64#69553F79#0#2_all$EXT" "$PORT/levels/ttm/6$EXT"
cp "_temp/SUPER MARIO 64#167CAC52#0#2_all$EXT" "$PORT/levels/ttm/7$EXT"
cp "_temp/SUPER MARIO 64#D1C5DE12#0#2_all$EXT" "$PORT/levels/ttm/8$EXT"

cp "_temp/SUPER MARIO 64#9066E92B#0#2_all$EXT" "$PORT/levels/vcutm/0$EXT"
cp "_temp/SUPER MARIO 64#A2F695A8#0#2_all$EXT" "$PORT/levels/vcutm/1$EXT"
cp "_temp/SUPER MARIO 64#094B9235#0#2_all$EXT" "$PORT/levels/vcutm/2$EXT"
cp "_temp/SUPER MARIO 64#7E7433A6#0#2_all$EXT" "$PORT/levels/vcutm/3$EXT"

cp "_temp/SUPER MARIO 64#CC57ADE9#0#2_all$EXT" "$PORT/levels/wdw/0$EXT"
cp "_temp/SUPER MARIO 64#74141022#0#2_all$EXT" "$PORT/levels/wdw/1$EXT"
cp "_temp/SUPER MARIO 64#9DF06E15#0#2_all$EXT" "$PORT/levels/wdw/2$EXT"
cp "_temp/SUPER MARIO 64#DCF4DE07#0#2_all$EXT" "$PORT/levels/wdw/3$EXT"
cp "_temp/SUPER MARIO 64#AF89C8F8#0#2_all$EXT" "$PORT/levels/wdw/4$EXT"

cp "_temp/SUPER MARIO 64#13C541EA#0#2_all$EXT" "$PORT/levels/wf/0$EXT"
cp "_temp/SUPER MARIO 64#C20FC383#0#2_all$EXT" "$PORT/levels/wf/1$EXT"
cp "_temp/SUPER MARIO 64#E61E849B#0#2_all$EXT" "$PORT/levels/wf/2$EXT"
cp "_temp/SUPER MARIO 64#E944A81B#0#2_all$EXT" "$PORT/levels/wf/3$EXT"
cp "_temp/SUPER MARIO 64#DC7BDE10#0#2_all$EXT" "$PORT/levels/wf/4$EXT"
cp "_temp/SUPER MARIO 64#931AB56D#3#1_all$EXT" "$PORT/levels/wf/5$EXT"

cp "_temp/SUPER MARIO 64#2CDB87DE#0#2_all$EXT" "$PORT/levels/wmotr/0$EXT"
cp "_temp/SUPER MARIO 64#33B314AF#0#2_all$EXT" "$PORT/levels/wmotr/1$EXT"
cp "_temp/SUPER MARIO 64#51D4DA7F#0#2_all$EXT" "$PORT/levels/wmotr/2$EXT"
cp "_temp/SUPER MARIO 64#BD4BA854#0#2_all$EXT" "$PORT/levels/wmotr/3$EXT"
cp "_temp/SUPER MARIO 64#04F846F7#0#2_all$EXT" "$PORT/levels/wmotr/4$EXT"

cp "_temp/SUPER MARIO 64#304306E0#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#6A925357#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#C199118A#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#E56F0BBF#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#7F9CCD83#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#33C58D86#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#9B4BEFB8#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#40FA0DCA#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#D951B3DA#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#92F79940#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#97E53259#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#3E40E693#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#BE04CE2E#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.09800$EXT"
cp "_temp/SUPER MARIO 64#4E6ECA8D#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#36F00556#0#2_all$EXT" "$PORT/textures/cave/hmc_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#65542036#3#2_all$EXT" "$PORT/textures/cave/hmc_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#6C3CE89F#3#2_all$EXT" "$PORT/textures/cave/hmc_textures.0C000$EXT"

cp "_temp/SUPER MARIO 64#4A5830AD#0#2_all$EXT" "$PORT/textures/effect/bubble.06048$EXT"
cp "_temp/SUPER MARIO 64#5D987F11#0#2_all$EXT" "$PORT/textures/effect/flower.00008$EXT"
cp "_temp/SUPER MARIO 64#7B2F0CE2#0#2_all$EXT" "$PORT/textures/effect/flower.00808$EXT"
cp "_temp/SUPER MARIO 64#77C14ADF#0#2_all$EXT" "$PORT/textures/effect/flower.01008$EXT"
cp "_temp/SUPER MARIO 64#8A94A19F#0#2_all$EXT" "$PORT/textures/effect/flower.01808$EXT"
cp "_temp/SUPER MARIO 64#F91048ED#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.02020$EXT"
cp "_temp/SUPER MARIO 64#D2A5D574#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.02820$EXT"
cp "_temp/SUPER MARIO 64#044F24EF#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.03020$EXT"
cp "_temp/SUPER MARIO 64#DDE47B60#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.03820$EXT"
cp "_temp/SUPER MARIO 64#7378A96F#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.04020$EXT"
cp "_temp/SUPER MARIO 64#55E07C1C#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.04820$EXT"
cp "_temp/SUPER MARIO 64#FF50BD43#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.05020$EXT"
cp "_temp/SUPER MARIO 64#85AEF726#0#2_all$EXT" "$PORT/textures/effect/lava_bubble.05820$EXT"
cp "_temp/SUPER MARIO 64#6A32A053#0#2_all$EXT" "$PORT/textures/effect/tiny_bubble.06AD8$EXT"
cp "_temp/SUPER MARIO 64#CB509D6A#0#2_all$EXT" "$PORT/textures/effect/tiny_bubble.0684C$EXT"

cp "_temp/SUPER MARIO 64#40568542#0#2_all$EXT" "$PORT/textures/fire/lll_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#E2E864A2#0#2_all$EXT" "$PORT/textures/fire/lll_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#7CFB23B0#0#2_all$EXT" "$PORT/textures/fire/lll_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#10675A01#0#2_all$EXT" "$PORT/textures/fire/lll_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#B1386A2E#0#2_all$EXT" "$PORT/textures/fire/lll_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#746A5D31#0#2_all$EXT" "$PORT/textures/fire/lll_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#10E452C9#0#2_all$EXT" "$PORT/textures/fire/lll_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#5996660E#0#2_all$EXT" "$PORT/textures/fire/lll_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#2EA7C781#0#2_all$EXT" "$PORT/textures/fire/lll_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#C6B026AA#0#2_all$EXT" "$PORT/textures/fire/lll_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#E49DCFB8#0#2_all$EXT" "$PORT/textures/fire/lll_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#9A729C51#0#2_all$EXT" "$PORT/textures/fire/lll_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#7ECF9E44#0#2_all$EXT" "$PORT/textures/fire/lll_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#BA6D7331#0#2_all$EXT" "$PORT/textures/fire/lll_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#82B146CD#0#2_all$EXT" "$PORT/textures/fire/lll_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#52BC0E5E#0#2_all$EXT" "$PORT/textures/fire/lll_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#5D3DF26F#0#2_all$EXT" "$PORT/textures/fire/lll_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#C518BF93#0#2_all$EXT" "$PORT/textures/fire/lll_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#A808D20A#0#2_all$EXT" "$PORT/textures/fire/lll_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#6626C09A#0#2_all$EXT" "$PORT/textures/fire/lll_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#6FA30457#0#2_all$EXT" "$PORT/textures/fire/lll_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#810A6136#0#2_all$EXT" "$PORT/textures/fire/lll_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#3F817C21#0#2_all$EXT" "$PORT/textures/fire/lll_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#B50DE959#0#2_all$EXT" "$PORT/textures/fire/lll_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#FDBCE221#0#2_all$EXT" "$PORT/textures/generic/bob_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#60AA80AA#0#2_all$EXT" "$PORT/textures/generic/bob_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#9CFE9F81#3#2_all$EXT" "$PORT/textures/generic/bob_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#7F832C86#0#2_all$EXT" "$PORT/textures/generic/bob_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#C6028757#0#2_all$EXT" "$PORT/textures/generic/bob_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#6DCA9CD5#0#2_all$EXT" "$PORT/textures/generic/bob_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#1448C073#0#2_all$EXT" "$PORT/textures/generic/bob_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#B7B83492#0#2_all$EXT" "$PORT/textures/generic/bob_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#04A35759#0#2_all$EXT" "$PORT/textures/generic/bob_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#4D03386E#0#2_all$EXT" "$PORT/textures/generic/bob_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#4B070BC3#0#2_all$EXT" "$PORT/textures/generic/bob_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#09208466#0#2_all$EXT" "$PORT/textures/generic/bob_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#DD78FBD8#0#2_all$EXT" "$PORT/textures/generic/bob_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#602EF33F#0#2_all$EXT" "$PORT/textures/generic/bob_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#AEF22277#0#2_all$EXT" "$PORT/textures/generic/bob_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#061A6C74#0#2_all$EXT" "$PORT/textures/generic/bob_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#3ECBD5D1#0#2_all$EXT" "$PORT/textures/generic/bob_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#F3CC9E98#0#2_all$EXT" "$PORT/textures/generic/bob_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#A3DA7F18#0#2_all$EXT" "$PORT/textures/generic/bob_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#9026CBA3#0#2_all$EXT" "$PORT/textures/generic/bob_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#215CE254#0#2_all$EXT" "$PORT/textures/generic/bob_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#AEC008C0#0#2_all$EXT" "$PORT/textures/generic/bob_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#4F265622#0#2_all$EXT" "$PORT/textures/grass/wf_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#60DD36F6#0#2_all$EXT" "$PORT/textures/grass/wf_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#9CFE9F81#3#2_all$EXT" "$PORT/textures/grass/wf_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#6F5155BA#3#2_all$EXT" "$PORT/textures/grass/wf_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#861DC3CF#0#2_all$EXT" "$PORT/textures/grass/wf_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#742FD706#0#2_all$EXT" "$PORT/textures/grass/wf_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#BD423336#0#2_all$EXT" "$PORT/textures/grass/wf_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#CF52A490#0#2_all$EXT" "$PORT/textures/grass/wf_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#93AE5517#0#2_all$EXT" "$PORT/textures/grass/wf_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#D4291CF0#0#2_all$EXT" "$PORT/textures/grass/wf_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#5C3873C6#0#2_all$EXT" "$PORT/textures/grass/wf_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#73505869#0#2_all$EXT" "$PORT/textures/grass/wf_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#53405A73#0#2_all$EXT" "$PORT/textures/grass/wf_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#81F9D9F5#0#2_all$EXT" "$PORT/textures/grass/wf_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#F3B23497#0#2_all$EXT" "$PORT/textures/grass/wf_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#79D8C749#0#2_all$EXT" "$PORT/textures/grass/wf_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#A11B5CF3#0#2_all$EXT" "$PORT/textures/grass/wf_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#2BC420F5#0#2_all$EXT" "$PORT/textures/grass/wf_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#B1F1CC42#0#2_all$EXT" "$PORT/textures/grass/wf_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#1EFFD4E0#0#2_all$EXT" "$PORT/textures/grass/wf_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#49A3631E#0#2_all$EXT" "$PORT/textures/grass/wf_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#9B61A230#0#2_all$EXT" "$PORT/textures/grass/wf_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#F5A3113C#0#2_all$EXT" "$PORT/textures/grass/wf_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#01755B95#0#2_all$EXT" "$PORT/textures/grass/wf_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#0D487556#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#0702FDE6#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#59D072F0#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#0303136F#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#1E520811#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#730DA5F2#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#9BE30B6E#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#022F69E3#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#6AA1BE26#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#DBCA0482#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#A6463A8D#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#7134B6DD#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#FDB50546#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#6DA0B1B9#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#4EEEFE7D#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#D10D7B85#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#9FCDDCE1#0#2_all$EXT" "$PORT/textures/inside/inside_castle_textures.09000$EXT"

cp "_temp/SUPER MARIO 64#0D821DF9#0#2_all$EXT" "$PORT/textures/intro_raw/hand_closed$EXT"
cp "_temp/SUPER MARIO 64#C61400EB#0#2_all$EXT" "$PORT/textures/intro_raw/hand_open$EXT"
cp "_temp/SUPER MARIO 64#16CE5DC5#3#1_all$EXT" "$PORT/textures/intro_raw/mario_face_shine$EXT"
cp "_temp/SUPER MARIO 64#1F31633F#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_0$EXT"
cp "_temp/SUPER MARIO 64#934DC3B3#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_1$EXT"
cp "_temp/SUPER MARIO 64#D04A00D5#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_2$EXT"
cp "_temp/SUPER MARIO 64#02040B88#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_3$EXT"
cp "_temp/SUPER MARIO 64#531BEBD4#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_4$EXT"
cp "_temp/SUPER MARIO 64#01BF1983#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_5$EXT"
cp "_temp/SUPER MARIO 64#686C2F97#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_6$EXT"
cp "_temp/SUPER MARIO 64#D314E722#0#2_all$EXT" "$PORT/textures/intro_raw/red_star_7$EXT"
cp "_temp/SUPER MARIO 64#44AE3D51#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_0$EXT"
cp "_temp/SUPER MARIO 64#CCEB38F6#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_1$EXT"
cp "_temp/SUPER MARIO 64#F476B374#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_2$EXT"
cp "_temp/SUPER MARIO 64#4EE94F84#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_3$EXT"
cp "_temp/SUPER MARIO 64#6BF1D4EA#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_4$EXT"
cp "_temp/SUPER MARIO 64#7F6733C7#0#2_all$EXT" "$PORT/textures/intro_raw/sparkle_5$EXT"
cp "_temp/SUPER MARIO 64#DF22EBFF#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_0$EXT"
cp "_temp/SUPER MARIO 64#DEE37E88#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_1$EXT"
cp "_temp/SUPER MARIO 64#188B6465#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_2$EXT"
cp "_temp/SUPER MARIO 64#087F8F7B#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_3$EXT"
cp "_temp/SUPER MARIO 64#DFF2A421#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_4$EXT"
cp "_temp/SUPER MARIO 64#D816C431#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_5$EXT"
cp "_temp/SUPER MARIO 64#A15FB7B8#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_6$EXT"
cp "_temp/SUPER MARIO 64#E7F503AC#0#2_all$EXT" "$PORT/textures/intro_raw/white_star_7$EXT"

cp "_temp/SUPER MARIO 64#79D25AFB#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#DBCA0482#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#1F5B1636#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#6E3243F8#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#0110314C#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#57C29C7D#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#19BB64C1#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#52F9E748#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#83D5BA14#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#D872CF6B#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#86FB0C9F#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#4C26A305#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#FF00D1BF#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#88654139#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#48B717EE#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#C9524EEE#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#933C8F9C#0#2_all$EXT" "$PORT/textures/machine/ttc_textures.08400$EXT"

cp "_temp/SUPER MARIO 64#E0C22A3C#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#D1C5DE12#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#8F523EF1#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#B4CAD4F7#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#D1F883F5#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.0C000$EXT"
cp "_temp/SUPER MARIO 64#4C001AD4#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#27B29129#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#9FA96B1F#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#07CF15A6#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#E383FD85#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#08758CDE#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#13E4332A#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#C072C80F#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#1F3B7ABC#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#D0AB7F94#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#76E8D87C#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#7A1B62B1#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#F902B80B#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#F8D78296#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#5CFEB1DB#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#D4E4F405#0#2_all$EXT" "$PORT/textures/mountain/ttm_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#370FC06B#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#C55C829F#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#A2C3484F#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#968FA8CE#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.0B400$EXT"
cp "_temp/SUPER MARIO 64#9CFE9F81#3#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.0BC00$EXT"
cp "_temp/SUPER MARIO 64#976DBC10#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#0C89D16B#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#F8303731#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#4166F73D#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#D7D14C92#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#8296D820#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#27ECE31D#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#726D3EFE#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#F92708AD#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#E22B8125#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#22F743BF#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#D5BD2CF3#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#E361666A#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#A6E20840#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#09820848#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#5F328955#0#2_all$EXT" "$PORT/textures/outside/castle_grounds_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#60D4A5C2#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05A00$EXT"
cp "_temp/SUPER MARIO 64#B6BA71D3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05A40$EXT"
cp "_temp/SUPER MARIO 64#97BAA58E#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05A80$EXT"
cp "_temp/SUPER MARIO 64#68F155A5#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05AC0$EXT"
cp "_temp/SUPER MARIO 64#87BA9198#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05B00$EXT"
cp "_temp/SUPER MARIO 64#B0D568A0#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05B40$EXT"
cp "_temp/SUPER MARIO 64#6CAB6E7C#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05B80$EXT"
cp "_temp/SUPER MARIO 64#AEB2B780#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05BC0$EXT"
cp "_temp/SUPER MARIO 64#897AB77F#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05C00$EXT"
cp "_temp/SUPER MARIO 64#86A979A6#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05C40$EXT"
cp "_temp/SUPER MARIO 64#8798CFBF#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05C80$EXT"
cp "_temp/SUPER MARIO 64#69B6B1A1#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05CC0$EXT"
cp "_temp/SUPER MARIO 64#8894B7A4#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05D00$EXT"
cp "_temp/SUPER MARIO 64#78A6E268#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05D40$EXT"
cp "_temp/SUPER MARIO 64#B9A790A1#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05D80$EXT"
cp "_temp/SUPER MARIO 64#9F8995A3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05DC0$EXT"
cp "_temp/SUPER MARIO 64#A8DF6863#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05E00$EXT"
cp "_temp/SUPER MARIO 64#988AA5AE#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05E40$EXT"
cp "_temp/SUPER MARIO 64#AFB97693#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05E80$EXT"
cp "_temp/SUPER MARIO 64#B0AB7771#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05EC0$EXT"
cp "_temp/SUPER MARIO 64#887AB795#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05F00$EXT"
cp "_temp/SUPER MARIO 64#69B2B1A2#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05F40$EXT"
cp "_temp/SUPER MARIO 64#A698B795#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05F80$EXT"
cp "_temp/SUPER MARIO 64#6BB0B3A0#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05FC0$EXT"
cp "_temp/SUPER MARIO 64#87BA54C8#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.059C0$EXT"
cp "_temp/SUPER MARIO 64#98BB898E#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05900$EXT"
cp "_temp/SUPER MARIO 64#D057B494#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05940$EXT"
cp "_temp/SUPER MARIO 64#B0F373B0#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.05980$EXT"
cp "_temp/SUPER MARIO 64#637878B3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06A00$EXT"
cp "_temp/SUPER MARIO 64#8A6886A4#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06A80$EXT"
cp "_temp/SUPER MARIO 64#8A4886A6#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06B40$EXT"
cp "_temp/SUPER MARIO 64#8A688695#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06B80$EXT"
cp "_temp/SUPER MARIO 64#5297B884#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06BC0$EXT"
cp "_temp/SUPER MARIO 64#7771686E#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06C00$EXT"
cp "_temp/SUPER MARIO 64#9C937792#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06C40$EXT"
cp "_temp/SUPER MARIO 64#9A887684#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06C80$EXT"
cp "_temp/SUPER MARIO 64#9B877585#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06CC0$EXT"
cp "_temp/SUPER MARIO 64#8A687694#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06D00$EXT"
cp "_temp/SUPER MARIO 64#6C6A6686#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06D40$EXT"
cp "_temp/SUPER MARIO 64#B35BE951#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06D80$EXT"
cp "_temp/SUPER MARIO 64#D1D18587#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06DC0$EXT"
cp "_temp/SUPER MARIO 64#9AC5A4A5#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06E00$EXT"
cp "_temp/SUPER MARIO 64#B97C9FAD#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06E40$EXT"
cp "_temp/SUPER MARIO 64#0ECC73B4#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06E80$EXT"
cp "_temp/SUPER MARIO 64#B1C091A7#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06EC0$EXT"
cp "_temp/SUPER MARIO 64#B0C2949A#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06F00$EXT"
cp "_temp/SUPER MARIO 64#92819878#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06F40$EXT"
cp "_temp/SUPER MARIO 64#8394A58A#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06F80$EXT"
cp "_temp/SUPER MARIO 64#92A5A679#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06FC0$EXT"
cp "_temp/SUPER MARIO 64#8D8F8692#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.060C0$EXT"
cp "_temp/SUPER MARIO 64#C1799951#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06000$EXT"
cp "_temp/SUPER MARIO 64#B9A79083#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06040$EXT"
cp "_temp/SUPER MARIO 64#9789A886#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06080$EXT"
cp "_temp/SUPER MARIO 64#B97D6191#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.061C0$EXT"
cp "_temp/SUPER MARIO 64#7D8D66C4#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06100$EXT"
cp "_temp/SUPER MARIO 64#BDF14875#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06140$EXT"
cp "_temp/SUPER MARIO 64#AC848284#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06180$EXT"
cp "_temp/SUPER MARIO 64#8187C266#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.062C0$EXT"
cp "_temp/SUPER MARIO 64#80A7C266#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06200$EXT"
cp "_temp/SUPER MARIO 64#6089A2C3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06240$EXT"
cp "_temp/SUPER MARIO 64#C089A462#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06280$EXT"
cp "_temp/SUPER MARIO 64#62A7C2A1#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.063C0$EXT"
cp "_temp/SUPER MARIO 64#BEA7A284#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06300$EXT"
cp "_temp/SUPER MARIO 64#AA77A182#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06340$EXT"
cp "_temp/SUPER MARIO 64#8D8682B6#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06380$EXT"
cp "_temp/SUPER MARIO 64#6AA886A1#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.064C0$EXT"
cp "_temp/SUPER MARIO 64#788AA257#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06400$EXT"
cp "_temp/SUPER MARIO 64#81697994#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06440$EXT"
cp "_temp/SUPER MARIO 64#49E284A3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06480$EXT"
cp "_temp/SUPER MARIO 64#A087A286#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.065C0$EXT"
cp "_temp/SUPER MARIO 64#64C774D2#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06500$EXT"
cp "_temp/SUPER MARIO 64#62A980C3#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06540$EXT"
cp "_temp/SUPER MARIO 64#8089A286#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06580$EXT"
cp "_temp/SUPER MARIO 64#8C87859E#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.066C0$EXT"
cp "_temp/SUPER MARIO 64#8187C284#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06600$EXT"
cp "_temp/SUPER MARIO 64#A2C46681#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06640$EXT"
cp "_temp/SUPER MARIO 64#C5C3A662#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06680$EXT"
cp "_temp/SUPER MARIO 64#A2C49F94#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.067C0$EXT"
cp "_temp/SUPER MARIO 64#7F8AC166#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06700$EXT"
cp "_temp/SUPER MARIO 64#C3688681#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06740$EXT"
cp "_temp/SUPER MARIO 64#9FA8C268#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06780$EXT"
cp "_temp/SUPER MARIO 64#8C7275A4#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.068C0$EXT"
cp "_temp/SUPER MARIO 64#BD8C84AF#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06800$EXT"
cp "_temp/SUPER MARIO 64#C2A56782#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06840$EXT"
cp "_temp/SUPER MARIO 64#D4A575A8#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06880$EXT"
cp "_temp/SUPER MARIO 64#A88FC5A2#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06900$EXT"
cp "_temp/SUPER MARIO 64#A48A62B0#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06940$EXT"
cp "_temp/SUPER MARIO 64#A77A8863#3#0_all$EXT" "$PORT/textures/segment2/font_graphics.06980$EXT"
cp "_temp/SUPER MARIO 64#7749B0D9#3#1_all$EXT" "$PORT/textures/segment2/segment2.0F458$EXT"
cp "_temp/SUPER MARIO 64#2D0C2E11#3#1_all$EXT" "$PORT/textures/segment2/segment2.0FC58$EXT"
cp "_temp/SUPER MARIO 64#6B1FC91A#0#2_all$EXT" "$PORT/textures/segment2/segment2.00000$EXT"
cp "_temp/SUPER MARIO 64#E4BD5580#0#2_all$EXT" "$PORT/textures/segment2/segment2.00200$EXT"
cp "_temp/SUPER MARIO 64#7C2D13C9#0#2_all$EXT" "$PORT/textures/segment2/segment2.00400$EXT"
cp "_temp/SUPER MARIO 64#9513887C#0#2_all$EXT" "$PORT/textures/segment2/segment2.00600$EXT"
cp "_temp/SUPER MARIO 64#4E4571C1#0#2_all$EXT" "$PORT/textures/segment2/segment2.00800$EXT"
cp "_temp/SUPER MARIO 64#5EF65DD9#0#2_all$EXT" "$PORT/textures/segment2/segment2.00A00$EXT"
cp "_temp/SUPER MARIO 64#0659AB56#0#2_all$EXT" "$PORT/textures/segment2/segment2.00C00$EXT"
cp "_temp/SUPER MARIO 64#336D534A#0#2_all$EXT" "$PORT/textures/segment2/segment2.00E00$EXT"
cp "_temp/SUPER MARIO 64#2A359204#0#2_all$EXT" "$PORT/textures/segment2/segment2.01000$EXT"
cp "_temp/SUPER MARIO 64#28A7F52B#0#2_all$EXT" "$PORT/textures/segment2/segment2.01200$EXT"
cp "_temp/SUPER MARIO 64#414026B4#0#2_all$EXT" "$PORT/textures/segment2/segment2.01400$EXT"
cp "_temp/SUPER MARIO 64#51BDAFFF#0#2_all$EXT" "$PORT/textures/segment2/segment2.01600$EXT"
cp "_temp/SUPER MARIO 64#6C64EB0B#0#2_all$EXT" "$PORT/textures/segment2/segment2.01800$EXT"
cp "_temp/SUPER MARIO 64#202D35BE#0#2_all$EXT" "$PORT/textures/segment2/segment2.01A00$EXT"
cp "_temp/SUPER MARIO 64#468BC569#0#2_all$EXT" "$PORT/textures/segment2/segment2.01C00$EXT"
cp "_temp/SUPER MARIO 64#D89B4538#0#2_all$EXT" "$PORT/textures/segment2/segment2.01E00$EXT"
cp "_temp/SUPER MARIO 64#7AB277B8#0#2_all$EXT" "$PORT/textures/segment2/segment2.02A00$EXT"
cp "_temp/SUPER MARIO 64#2B851F69#0#2_all$EXT" "$PORT/textures/segment2/segment2.02C00$EXT"
cp "_temp/SUPER MARIO 64#6BC75681#0#2_all$EXT" "$PORT/textures/segment2/segment2.02E00$EXT"
cp "_temp/SUPER MARIO 64#7CC51E15#0#2_all$EXT" "$PORT/textures/segment2/segment2.02000$EXT"
cp "_temp/SUPER MARIO 64#E2DE3E2B#0#2_all$EXT" "$PORT/textures/segment2/segment2.02200$EXT"
cp "_temp/SUPER MARIO 64#FC10A1B3#0#2_all$EXT" "$PORT/textures/segment2/segment2.02400$EXT"
cp "_temp/SUPER MARIO 64#CDA7F3BF#0#2_all$EXT" "$PORT/textures/segment2/segment2.02600$EXT"
cp "_temp/SUPER MARIO 64#DB3C7C79#0#2_all$EXT" "$PORT/textures/segment2/segment2.02800$EXT"
cp "_temp/SUPER MARIO 64#A2013A12#0#2_all$EXT" "$PORT/textures/segment2/segment2.03A00$EXT"
cp "_temp/SUPER MARIO 64#F5974867#0#2_all$EXT" "$PORT/textures/segment2/segment2.03C00$EXT"
cp "_temp/SUPER MARIO 64#78CE86A9#0#2_all$EXT" "$PORT/textures/segment2/segment2.03E00$EXT"
cp "_temp/SUPER MARIO 64#08C865BC#0#2_all$EXT" "$PORT/textures/segment2/segment2.03000$EXT"
cp "_temp/SUPER MARIO 64#86B7D553#0#2_all$EXT" "$PORT/textures/segment2/segment2.03200$EXT"
cp "_temp/SUPER MARIO 64#52A84252#0#2_all$EXT" "$PORT/textures/segment2/segment2.03600$EXT"
cp "_temp/SUPER MARIO 64#134A35B3#0#2_all$EXT" "$PORT/textures/segment2/segment2.03800$EXT"
cp "_temp/SUPER MARIO 64#A0974D75#0#2_all$EXT" "$PORT/textures/segment2/segment2.04A00$EXT"
cp "_temp/SUPER MARIO 64#FFEA1FFE#0#2_all$EXT" "$PORT/textures/segment2/segment2.04000$EXT"
cp "_temp/SUPER MARIO 64#F7348D7B#0#2_all$EXT" "$PORT/textures/segment2/segment2.04200$EXT"
cp "_temp/SUPER MARIO 64#095CCD5F#0#2_all$EXT" "$PORT/textures/segment2/segment2.04400$EXT"
cp "_temp/SUPER MARIO 64#0F53E6DA#0#2_all$EXT" "$PORT/textures/segment2/segment2.04600$EXT"
cp "_temp/SUPER MARIO 64#81BB18E0#0#2_all$EXT" "$PORT/textures/segment2/segment2.04800$EXT"
cp "_temp/SUPER MARIO 64#580E00A9#0#2_all$EXT" "$PORT/textures/segment2/segment2.05A00$EXT"
cp "_temp/SUPER MARIO 64#362E3E52#0#2_all$EXT" "$PORT/textures/segment2/segment2.05C00$EXT"
cp "_temp/SUPER MARIO 64#EBE128AA#0#2_all$EXT" "$PORT/textures/segment2/segment2.05000$EXT"
cp "_temp/SUPER MARIO 64#0AB6E7BF#0#2_all$EXT" "$PORT/textures/segment2/segment2.05400$EXT"
cp "_temp/SUPER MARIO 64#92AD1EEF#0#2_all$EXT" "$PORT/textures/segment2/segment2.05600$EXT"
cp "_temp/SUPER MARIO 64#88703C55#0#2_all$EXT" "$PORT/textures/segment2/segment2.05800$EXT"
cp "_temp/SUPER MARIO 64#C91C9210#0#2_all$EXT" "$PORT/textures/segment2/segment2.06A00$EXT"
cp "_temp/SUPER MARIO 64#CE8E25FA#0#2_all$EXT" "$PORT/textures/segment2/segment2.06A80$EXT"
cp "_temp/SUPER MARIO 64#F2979267#0#2_all$EXT" "$PORT/textures/segment2/segment2.06B00$EXT"
cp "_temp/SUPER MARIO 64#74B2E682#0#2_all$EXT" "$PORT/textures/segment2/segment2.06B80$EXT"
cp "_temp/SUPER MARIO 64#FC58ED51#0#2_all$EXT" "$PORT/textures/segment2/segment2.06C00$EXT"
cp "_temp/SUPER MARIO 64#4EE951E9#0#2_all$EXT" "$PORT/textures/segment2/segment2.06C80$EXT"
cp "_temp/SUPER MARIO 64#E67C070B#0#2_all$EXT" "$PORT/textures/segment2/segment2.06D00$EXT"
cp "_temp/SUPER MARIO 64#988F8D4A#0#2_all$EXT" "$PORT/textures/segment2/segment2.06D80$EXT"
cp "_temp/SUPER MARIO 64#784949CA#0#2_all$EXT" "$PORT/textures/segment2/segment2.06E00$EXT"
cp "_temp/SUPER MARIO 64#D6F1A677#0#2_all$EXT" "$PORT/textures/segment2/segment2.06E80$EXT"
cp "_temp/SUPER MARIO 64#48A3E423#0#2_all$EXT" "$PORT/textures/segment2/segment2.06F00$EXT"
cp "_temp/SUPER MARIO 64#0DF2EE56#0#2_all$EXT" "$PORT/textures/segment2/segment2.06F80$EXT"
cp "_temp/SUPER MARIO 64#24E61683#0#2_all$EXT" "$PORT/textures/segment2/segment2.06200$EXT"
cp "_temp/SUPER MARIO 64#D2E92870#0#2_all$EXT" "$PORT/textures/segment2/segment2.06280$EXT"
cp "_temp/SUPER MARIO 64#02330CCD#0#2_all$EXT" "$PORT/textures/segment2/segment2.06300$EXT"
cp "_temp/SUPER MARIO 64#DA971B4E#0#2_all$EXT" "$PORT/textures/segment2/segment2.06380$EXT"
cp "_temp/SUPER MARIO 64#3DE0ED4E#0#2_all$EXT" "$PORT/textures/segment2/segment2.06400$EXT"
cp "_temp/SUPER MARIO 64#2D898713#0#2_all$EXT" "$PORT/textures/segment2/segment2.06480$EXT"
cp "_temp/SUPER MARIO 64#962278D5#0#2_all$EXT" "$PORT/textures/segment2/segment2.06500$EXT"
cp "_temp/SUPER MARIO 64#38AFCD8F#0#2_all$EXT" "$PORT/textures/segment2/segment2.06580$EXT"
cp "_temp/SUPER MARIO 64#1CB6DC98#0#2_all$EXT" "$PORT/textures/segment2/segment2.06600$EXT"
cp "_temp/SUPER MARIO 64#2447B7F9#0#2_all$EXT" "$PORT/textures/segment2/segment2.06680$EXT"
cp "_temp/SUPER MARIO 64#39E90B67#0#2_all$EXT" "$PORT/textures/segment2/segment2.06700$EXT"
cp "_temp/SUPER MARIO 64#ECD57CE8#0#2_all$EXT" "$PORT/textures/segment2/segment2.06780$EXT"
cp "_temp/SUPER MARIO 64#276489C6#0#2_all$EXT" "$PORT/textures/segment2/segment2.06800$EXT"
cp "_temp/SUPER MARIO 64#2811C57F#0#2_all$EXT" "$PORT/textures/segment2/segment2.06880$EXT"
cp "_temp/SUPER MARIO 64#3CE9E494#0#2_all$EXT" "$PORT/textures/segment2/segment2.06900$EXT"
cp "_temp/SUPER MARIO 64#75D9483A#0#2_all$EXT" "$PORT/textures/segment2/segment2.06980$EXT"
cp "_temp/SUPER MARIO 64#6F32A4FB#0#2_all$EXT" "$PORT/textures/segment2/segment2.07B50$EXT"
cp "_temp/SUPER MARIO 64#438CC5BE#0#2_all$EXT" "$PORT/textures/segment2/segment2.07D50$EXT"
cp "_temp/SUPER MARIO 64#676B6CF3#0#2_all$EXT" "$PORT/textures/segment2/segment2.07F50$EXT"
cp "_temp/SUPER MARIO 64#D8502FF0#0#2_all$EXT" "$PORT/textures/segment2/segment2.07000$EXT"
cp "_temp/SUPER MARIO 64#25B219C7#0#2_all$EXT" "$PORT/textures/segment2/segment2.07080$EXT"
cp "_temp/SUPER MARIO 64#A7398F08#0#2_all$EXT" "$PORT/textures/segment2/segment2.081D0$EXT"
cp "_temp/SUPER MARIO 64#EC24C279#0#2_all$EXT" "$PORT/textures/segment2/segment2.08150$EXT"
cp "_temp/SUPER MARIO 64#DFFBB688#0#2_all$EXT" "$PORT/textures/segment2/segment2.11C58$EXT"
cp "_temp/SUPER MARIO 64#06FF13AD#0#2_all$EXT" "$PORT/textures/segment2/segment2.12C58$EXT"
cp "_temp/SUPER MARIO 64#3F817C21#0#2_all$EXT" "$PORT/textures/segment2/segment2.13C58$EXT"
cp "_temp/SUPER MARIO 64#CB57B47B#3#1_all$EXT" "$PORT/textures/segment2/segment2.10458$EXT"
cp "_temp/SUPER MARIO 64#98347689#3#1_all$EXT" "$PORT/textures/segment2/segment2.11458$EXT"
cp "_temp/SUPER MARIO 64#5095921B#0#2_all$EXT" "$PORT/textures/segment2/segment2.12458$EXT"
cp "_temp/SUPER MARIO 64#4A0AF053#3#2_all$EXT" "$PORT/textures/segment2/segment2.13458$EXT"
cp "_temp/SUPER MARIO 64#A44DF3E3#3#1_all$EXT" "$PORT/textures/segment2/shadow_quarter_circle$EXT"
cp "_temp/SUPER MARIO 64#931AB56D#3#1_all$EXT" "$PORT/textures/segment2/shadow_quarter_square$EXT"

cp "_temp/SUPER MARIO 64#CF717C3C#0#2_all$EXT" "$PORT/textures/sky/metal_hole$EXT"
cp "_temp/SUPER MARIO 64#CD71304B#0#2_all$EXT" "$PORT/textures/sky/rr_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#5D5BB4D6#0#2_all$EXT" "$PORT/textures/sky/rr_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#EC819D1B#0#2_all$EXT" "$PORT/textures/sky/rr_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#D872790D#0#2_all$EXT" "$PORT/textures/sky/rr_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#8FC7FAC2#0#2_all$EXT" "$PORT/textures/sky/rr_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#FE7EC2B3#0#2_all$EXT" "$PORT/textures/sky/rr_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#B63A3055#0#2_all$EXT" "$PORT/textures/sky/rr_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#50964858#0#2_all$EXT" "$PORT/textures/sky/rr_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#A11B5CF3#0#2_all$EXT" "$PORT/textures/sky/rr_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#E473FB5D#0#2_all$EXT" "$PORT/textures/sky/rr_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#E0C22A3C#0#2_all$EXT" "$PORT/textures/sky/rr_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#7E5C24F7#0#2_all$EXT" "$PORT/textures/sky/rr_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#B114863B#0#2_all$EXT" "$PORT/textures/sky/rr_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#7A6AB5A7#0#2_all$EXT" "$PORT/textures/sky/rr_textures.08000$EXT"

cp "_temp/SUPER MARIO 64#02429854#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.1$EXT"
cp "_temp/SUPER MARIO 64#0571FC7C#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.15$EXT"
cp "_temp/SUPER MARIO 64#0D6A8490#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.29$EXT"
cp "_temp/SUPER MARIO 64#165F940A#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.6$EXT"
cp "_temp/SUPER MARIO 64#339B3765#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.31$EXT"
cp "_temp/SUPER MARIO 64#3556A0C8#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.4$EXT"
cp "_temp/SUPER MARIO 64#46BEFF45#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.21$EXT"
cp "_temp/SUPER MARIO 64#4ED18843#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.13$EXT"
cp "_temp/SUPER MARIO 64#51B5CD93#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.20$EXT"
cp "_temp/SUPER MARIO 64#543AE92E#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.0$EXT"
cp "_temp/SUPER MARIO 64#5691C606#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.17$EXT"
cp "_temp/SUPER MARIO 64#5DDD4BF0#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.8$EXT"
cp "_temp/SUPER MARIO 64#5E819C11#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.5$EXT"
cp "_temp/SUPER MARIO 64#63820423#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.28$EXT"
cp "_temp/SUPER MARIO 64#6E88F5E0#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.39$EXT"
cp "_temp/SUPER MARIO 64#72D28485#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.7$EXT"
cp "_temp/SUPER MARIO 64#73276400#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.25$EXT"
cp "_temp/SUPER MARIO 64#7F0C0D1A#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.35$EXT"
cp "_temp/SUPER MARIO 64#869D1C9B#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.12$EXT"
cp "_temp/SUPER MARIO 64#888F7075#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.9$EXT"
cp "_temp/SUPER MARIO 64#8EDC5BE4#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.32$EXT"
cp "_temp/SUPER MARIO 64#9663B6F7#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.27$EXT"
cp "_temp/SUPER MARIO 64#9C6FA38A#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.18$EXT"
cp "_temp/SUPER MARIO 64#9E520CB2#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.16$EXT"
cp "_temp/SUPER MARIO 64#AA5A7898#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.11$EXT"
cp "_temp/SUPER MARIO 64#ACEC3F69#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.37$EXT"
cp "_temp/SUPER MARIO 64#AF7B75C2#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.38$EXT"
cp "_temp/SUPER MARIO 64#B3F25163#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.24$EXT"
cp "_temp/SUPER MARIO 64#B45578DC#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.34$EXT"
cp "_temp/SUPER MARIO 64#B616A7C2#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.14$EXT"
cp "_temp/SUPER MARIO 64#BA8930C5#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.2$EXT"
cp "_temp/SUPER MARIO 64#BD9C82DE#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.30$EXT"
cp "_temp/SUPER MARIO 64#BE721E4B#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.10$EXT"
cp "_temp/SUPER MARIO 64#C55CA18E#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.22$EXT"
cp "_temp/SUPER MARIO 64#C99F67F2#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.3$EXT"
cp "_temp/SUPER MARIO 64#D678C04F#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.19$EXT"
cp "_temp/SUPER MARIO 64#D910F455#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.36$EXT"
cp "_temp/SUPER MARIO 64#E2FAD209#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.33$EXT"
cp "_temp/SUPER MARIO 64#EB0DFB0A#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.23$EXT"
cp "_temp/SUPER MARIO 64#F5E69D71#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.26$EXT"
cp "_temp/SUPER MARIO 64#211EDF33#0#2_all$EXT" "$PORT/textures/skyboxes/bbh/bbh.40$EXT"

cp "_temp/SUPER MARIO 64#00B11930#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.33$EXT"
cp "_temp/SUPER MARIO 64#05D86D02#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.55$EXT"
cp "_temp/SUPER MARIO 64#0EE19C09#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.25$EXT"
cp "_temp/SUPER MARIO 64#18102121#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.52$EXT"
cp "_temp/SUPER MARIO 64#1EA893D2#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.57$EXT"
cp "_temp/SUPER MARIO 64#216A674D#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.54$EXT"
cp "_temp/SUPER MARIO 64#22253C7E#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.5$EXT"
cp "_temp/SUPER MARIO 64#27D9AF1F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.10$EXT"
cp "_temp/SUPER MARIO 64#2CFA4B7F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.61$EXT"
cp "_temp/SUPER MARIO 64#2FC064C1#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.32$EXT"
cp "_temp/SUPER MARIO 64#2FE9009A#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.11$EXT"
cp "_temp/SUPER MARIO 64#310F4C2C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.6$EXT"
cp "_temp/SUPER MARIO 64#3324B340#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.8$EXT"
cp "_temp/SUPER MARIO 64#3CCF8886#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.27$EXT"
cp "_temp/SUPER MARIO 64#46649148#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.56$EXT"
cp "_temp/SUPER MARIO 64#48E57582#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.13$EXT"
cp "_temp/SUPER MARIO 64#4CDB236C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.36$EXT"
cp "_temp/SUPER MARIO 64#4E80FA6F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.15$EXT"
cp "_temp/SUPER MARIO 64#5050548F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.22$EXT"
cp "_temp/SUPER MARIO 64#58C547BD#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.19$EXT"
cp "_temp/SUPER MARIO 64#5B01FAF9#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.2$EXT"
cp "_temp/SUPER MARIO 64#6218470C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.14$EXT"
cp "_temp/SUPER MARIO 64#68C4A756#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.35$EXT"
cp "_temp/SUPER MARIO 64#6EB6822E#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.49$EXT"
cp "_temp/SUPER MARIO 64#718C4694#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.34$EXT"
cp "_temp/SUPER MARIO 64#75F39E26#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.4$EXT"
cp "_temp/SUPER MARIO 64#7AF76431#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.45$EXT"
cp "_temp/SUPER MARIO 64#7F5468E5#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.43$EXT"
cp "_temp/SUPER MARIO 64#7FCB976C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.29$EXT"
cp "_temp/SUPER MARIO 64#8093D98D#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.12$EXT"
cp "_temp/SUPER MARIO 64#908BB0A5#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.30$EXT"
cp "_temp/SUPER MARIO 64#9205F8FC#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.37$EXT"
cp "_temp/SUPER MARIO 64#92914C1C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.63$EXT"
cp "_temp/SUPER MARIO 64#93507E3B#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.28$EXT"
cp "_temp/SUPER MARIO 64#937650B4#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.16$EXT"
cp "_temp/SUPER MARIO 64#9E94B9F1#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.26$EXT"
cp "_temp/SUPER MARIO 64#9F6DD214#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.17$EXT"
cp "_temp/SUPER MARIO 64#A4316E88#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.31$EXT"
cp "_temp/SUPER MARIO 64#ADB81440#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.51$EXT"
cp "_temp/SUPER MARIO 64#AE39BA68#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.58$EXT"
cp "_temp/SUPER MARIO 64#B2EFD400#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.47$EXT"
cp "_temp/SUPER MARIO 64#B76D42DD#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.21$EXT"
cp "_temp/SUPER MARIO 64#BE0750A6#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.62$EXT"
cp "_temp/SUPER MARIO 64#BE5AB2EE#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.44$EXT"
cp "_temp/SUPER MARIO 64#BE610D43#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.1$EXT"
cp "_temp/SUPER MARIO 64#BFA0DFE0#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.59$EXT"
cp "_temp/SUPER MARIO 64#BFE56F11#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.53$EXT"
cp "_temp/SUPER MARIO 64#C30B4FE2#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.40$EXT"
cp "_temp/SUPER MARIO 64#C39651E5#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.0$EXT"
cp "_temp/SUPER MARIO 64#C4C331E8#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.42$EXT"
cp "_temp/SUPER MARIO 64#C4C356FA#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.50$EXT"
cp "_temp/SUPER MARIO 64#CB67DA9F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.23$EXT"
cp "_temp/SUPER MARIO 64#CC89FE99#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.39$EXT"
cp "_temp/SUPER MARIO 64#D1B72B53#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.7$EXT"
cp "_temp/SUPER MARIO 64#D4FECE2C#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.3$EXT"
cp "_temp/SUPER MARIO 64#D660A2AE#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.60$EXT"
cp "_temp/SUPER MARIO 64#D89FBCA9#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.18$EXT"
cp "_temp/SUPER MARIO 64#D8A463DF#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.48$EXT"
cp "_temp/SUPER MARIO 64#D97FB4F5#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.38$EXT"
cp "_temp/SUPER MARIO 64#DC08D520#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.9$EXT"
cp "_temp/SUPER MARIO 64#DE38650F#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.46$EXT"
cp "_temp/SUPER MARIO 64#DF07ED35#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.20$EXT"
cp "_temp/SUPER MARIO 64#FAAFF848#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.41$EXT"
cp "_temp/SUPER MARIO 64#FC6EF688#0#2_all$EXT" "$PORT/textures/skyboxes/bidw/bidw.24$EXT"

cp "_temp/SUPER MARIO 64#07155D85#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.35$EXT"
cp "_temp/SUPER MARIO 64#07FF7CD2#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.29$EXT"
cp "_temp/SUPER MARIO 64#22348F8B#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.7$EXT"
cp "_temp/SUPER MARIO 64#27B1AA10#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.1$EXT"
cp "_temp/SUPER MARIO 64#2FA4B137#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.27$EXT"
cp "_temp/SUPER MARIO 64#3342AE2E#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.18$EXT"
cp "_temp/SUPER MARIO 64#3D7ADDE3#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.8$EXT"
cp "_temp/SUPER MARIO 64#4783C2BF#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.19$EXT"
cp "_temp/SUPER MARIO 64#49D68918#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.3$EXT"
cp "_temp/SUPER MARIO 64#4F1CAC41#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.21$EXT"
cp "_temp/SUPER MARIO 64#5FC183BA#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.26$EXT"
cp "_temp/SUPER MARIO 64#63860579#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.16$EXT"
cp "_temp/SUPER MARIO 64#6872E4FF#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.14$EXT"
cp "_temp/SUPER MARIO 64#6E969590#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.40$EXT"
cp "_temp/SUPER MARIO 64#81175ED5#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.32$EXT"
cp "_temp/SUPER MARIO 64#812626F9#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.33$EXT"
cp "_temp/SUPER MARIO 64#99302633#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.37$EXT"
cp "_temp/SUPER MARIO 64#9E30AED1#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.10$EXT"
cp "_temp/SUPER MARIO 64#9E4203FF#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.13$EXT"
cp "_temp/SUPER MARIO 64#9EB76583#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.34$EXT"
cp "_temp/SUPER MARIO 64#A46217AB#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.11$EXT"
cp "_temp/SUPER MARIO 64#A5063ADB#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.36$EXT"
cp "_temp/SUPER MARIO 64#B453CC4A#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.24$EXT"
cp "_temp/SUPER MARIO 64#B8AB2C4E#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.4$EXT"
cp "_temp/SUPER MARIO 64#BB5327E0#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.15$EXT"
cp "_temp/SUPER MARIO 64#BDE331E7#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.25$EXT"
cp "_temp/SUPER MARIO 64#BFAFF600#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.9$EXT"
cp "_temp/SUPER MARIO 64#CE142635#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.30$EXT"
cp "_temp/SUPER MARIO 64#CEB6CAA7#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.39$EXT"
cp "_temp/SUPER MARIO 64#CF390916#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.22$EXT"
cp "_temp/SUPER MARIO 64#DAA65AFC#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.12$EXT"
cp "_temp/SUPER MARIO 64#DCDCA548#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.23$EXT"
cp "_temp/SUPER MARIO 64#DDBE80A7#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.0$EXT"
cp "_temp/SUPER MARIO 64#DF0E0D87#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.41$EXT"
cp "_temp/SUPER MARIO 64#E00D840E#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.20$EXT"
cp "_temp/SUPER MARIO 64#E398C0E5#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.2$EXT"
cp "_temp/SUPER MARIO 64#E6061D88#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.42$EXT"
cp "_temp/SUPER MARIO 64#E6959DA0#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.43$EXT"
cp "_temp/SUPER MARIO 64#E69D9617#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.44$EXT"
cp "_temp/SUPER MARIO 64#E7161D98#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.45$EXT"
cp "_temp/SUPER MARIO 64#EA566CB8#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.28$EXT"
cp "_temp/SUPER MARIO 64#EE949D98#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.46$EXT"
cp "_temp/SUPER MARIO 64#EF161D97#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.47$EXT"
cp "_temp/SUPER MARIO 64#EF44FC69#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.31$EXT"
cp "_temp/SUPER MARIO 64#F8CC42D7#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.6$EXT"
cp "_temp/SUPER MARIO 64#F9889333#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.38$EXT"
cp "_temp/SUPER MARIO 64#FF309AA3#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.5$EXT"
cp "_temp/SUPER MARIO 64#FFDEBBC5#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.17$EXT"
cp "_temp/SUPER MARIO 64#211EDF33#0#2_all$EXT" "$PORT/textures/skyboxes/bitfs/bitfs.48$EXT"

cp "_temp/SUPER MARIO 64#069F68D5#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.3$EXT"
cp "_temp/SUPER MARIO 64#0771AB54#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.4$EXT"
cp "_temp/SUPER MARIO 64#0A18ADCA#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.28$EXT"
cp "_temp/SUPER MARIO 64#11543850#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.62$EXT"
cp "_temp/SUPER MARIO 64#1450F56E#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.21$EXT"
cp "_temp/SUPER MARIO 64#14C6A0DB#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.11$EXT"
cp "_temp/SUPER MARIO 64#17F35F3C#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.32$EXT"
cp "_temp/SUPER MARIO 64#18A7104C#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.19$EXT"
cp "_temp/SUPER MARIO 64#21854115#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.30$EXT"
cp "_temp/SUPER MARIO 64#24AD7055#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.26$EXT"
cp "_temp/SUPER MARIO 64#2A9F12C7#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.14$EXT"
cp "_temp/SUPER MARIO 64#2B3F9B9C#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.33$EXT"
cp "_temp/SUPER MARIO 64#2C246943#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.59$EXT"
cp "_temp/SUPER MARIO 64#2C44217C#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.57$EXT"
cp "_temp/SUPER MARIO 64#2CE5532E#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.63$EXT"
cp "_temp/SUPER MARIO 64#2ECE83FA#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.8$EXT"
cp "_temp/SUPER MARIO 64#308C95F5#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.20$EXT"
cp "_temp/SUPER MARIO 64#34E02944#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.46$EXT"
cp "_temp/SUPER MARIO 64#41D56401#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.22$EXT"
cp "_temp/SUPER MARIO 64#42F2325A#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.13$EXT"
cp "_temp/SUPER MARIO 64#44D5AA4B#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.43$EXT"
cp "_temp/SUPER MARIO 64#452AAD60#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.47$EXT"
cp "_temp/SUPER MARIO 64#486F9BD1#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.27$EXT"
cp "_temp/SUPER MARIO 64#4CEEF375#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.15$EXT"
cp "_temp/SUPER MARIO 64#4F503C6E#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.24$EXT"
cp "_temp/SUPER MARIO 64#51256D7A#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.2$EXT"
cp "_temp/SUPER MARIO 64#58A11D1E#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.37$EXT"
cp "_temp/SUPER MARIO 64#5C153DAF#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.34$EXT"
cp "_temp/SUPER MARIO 64#677A5E03#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.41$EXT"
cp "_temp/SUPER MARIO 64#688DEFB4#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.31$EXT"
cp "_temp/SUPER MARIO 64#68CBBCD3#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.9$EXT"
cp "_temp/SUPER MARIO 64#6DABF6C8#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.12$EXT"
cp "_temp/SUPER MARIO 64#6F964986#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.1$EXT"
cp "_temp/SUPER MARIO 64#747B1B07#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.55$EXT"
cp "_temp/SUPER MARIO 64#795FE3B9#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.25$EXT"
cp "_temp/SUPER MARIO 64#7D398EF0#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.50$EXT"
cp "_temp/SUPER MARIO 64#7DCC1AB5#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.38$EXT"
cp "_temp/SUPER MARIO 64#8141BBBC#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.42$EXT"
cp "_temp/SUPER MARIO 64#84EB583E#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.6$EXT"
cp "_temp/SUPER MARIO 64#930392D9#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.44$EXT"
cp "_temp/SUPER MARIO 64#9791B947#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.56$EXT"
cp "_temp/SUPER MARIO 64#9AF43B47#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.61$EXT"
cp "_temp/SUPER MARIO 64#A349A078#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.36$EXT"
cp "_temp/SUPER MARIO 64#A436E205#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.29$EXT"
cp "_temp/SUPER MARIO 64#A9F1685A#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.17$EXT"
cp "_temp/SUPER MARIO 64#AA0F24EC#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.7$EXT"
cp "_temp/SUPER MARIO 64#B2444E60#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.58$EXT"
cp "_temp/SUPER MARIO 64#B26D42C0#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.51$EXT"
cp "_temp/SUPER MARIO 64#B271DB5B#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.60$EXT"
cp "_temp/SUPER MARIO 64#B5DA0B63#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.10$EXT"
cp "_temp/SUPER MARIO 64#B602AB34#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.53$EXT"
cp "_temp/SUPER MARIO 64#B92BF6C1#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.52$EXT"
cp "_temp/SUPER MARIO 64#C80078C1#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.18$EXT"
cp "_temp/SUPER MARIO 64#D6ACB89D#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.16$EXT"
cp "_temp/SUPER MARIO 64#D97D5A21#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.23$EXT"
cp "_temp/SUPER MARIO 64#DB37FF1F#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.48$EXT"
cp "_temp/SUPER MARIO 64#DD5AE929#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.0$EXT"
cp "_temp/SUPER MARIO 64#DE415A3C#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.40$EXT"
cp "_temp/SUPER MARIO 64#E144C219#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.49$EXT"
cp "_temp/SUPER MARIO 64#EC004254#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.39$EXT"
cp "_temp/SUPER MARIO 64#F5D9E5BF#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.5$EXT"
cp "_temp/SUPER MARIO 64#F69986CE#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.45$EXT"
cp "_temp/SUPER MARIO 64#FC0DD433#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.54$EXT"
cp "_temp/SUPER MARIO 64#FCFC8637#0#2_all$EXT" "$PORT/textures/skyboxes/bits/bits.35$EXT"

cp "_temp/SUPER MARIO 64#C136BC10#0#2_all$EXT" "$PORT/levels/ending/cake.0$EXT"
cp "_temp/SUPER MARIO 64#8A4DF121#0#2_all$EXT" "$PORT/levels/ending/cake.1$EXT"
cp "_temp/SUPER MARIO 64#8A4DF121#0#2_all$EXT" "$PORT/levels/ending/cake.2$EXT"
cp "_temp/SUPER MARIO 64#77C0FF44#0#2_all$EXT" "$PORT/levels/ending/cake.3$EXT"
cp "_temp/SUPER MARIO 64#0430DE55#0#2_all$EXT" "$PORT/levels/ending/cake.25$EXT"
cp "_temp/SUPER MARIO 64#07C7C401#0#2_all$EXT" "$PORT/levels/ending/cake.20$EXT"
cp "_temp/SUPER MARIO 64#086772E7#0#2_all$EXT" "$PORT/levels/ending/cake.30$EXT"
cp "_temp/SUPER MARIO 64#108D6CAE#0#2_all$EXT" "$PORT/levels/ending/cake.43$EXT"
cp "_temp/SUPER MARIO 64#10C87D57#0#2_all$EXT" "$PORT/levels/ending/cake.23$EXT"
cp "_temp/SUPER MARIO 64#163F6E7C#0#2_all$EXT" "$PORT/levels/ending/cake.28$EXT"
cp "_temp/SUPER MARIO 64#16DB7146#0#2_all$EXT" "$PORT/levels/ending/cake.38$EXT"
cp "_temp/SUPER MARIO 64#1A6F8A0E#0#2_all$EXT" "$PORT/levels/ending/cake.34$EXT"
cp "_temp/SUPER MARIO 64#21A99BEF#0#2_all$EXT" "$PORT/levels/ending/cake.39$EXT"
cp "_temp/SUPER MARIO 64#2282C30A#0#2_all$EXT" "$PORT/levels/ending/cake.45$EXT"
cp "_temp/SUPER MARIO 64#2677A2A0#0#2_all$EXT" "$PORT/levels/ending/cake.33$EXT"
cp "_temp/SUPER MARIO 64#292C40A1#0#2_all$EXT" "$PORT/levels/ending/cake.13$EXT"
cp "_temp/SUPER MARIO 64#39A50598#0#2_all$EXT" "$PORT/levels/ending/cake.14$EXT"
cp "_temp/SUPER MARIO 64#40AA862F#0#2_all$EXT" "$PORT/levels/ending/cake.6$EXT"
cp "_temp/SUPER MARIO 64#537D0A34#0#2_all$EXT" "$PORT/levels/ending/cake.37$EXT"
cp "_temp/SUPER MARIO 64#5663D126#0#2_all$EXT" "$PORT/levels/ending/cake.17$EXT"
cp "_temp/SUPER MARIO 64#59C798D4#0#2_all$EXT" "$PORT/levels/ending/cake.31$EXT"
cp "_temp/SUPER MARIO 64#60BCEF6E#0#2_all$EXT" "$PORT/levels/ending/cake.7$EXT"
cp "_temp/SUPER MARIO 64#6926316A#0#2_all$EXT" "$PORT/levels/ending/cake.27$EXT"
cp "_temp/SUPER MARIO 64#6A799547#0#2_all$EXT" "$PORT/levels/ending/cake.40$EXT"
cp "_temp/SUPER MARIO 64#6BC84AF5#0#2_all$EXT" "$PORT/levels/ending/cake.46$EXT"
cp "_temp/SUPER MARIO 64#6C706165#0#2_all$EXT" "$PORT/levels/ending/cake.22$EXT"
cp "_temp/SUPER MARIO 64#72A1D4B8#0#2_all$EXT" "$PORT/levels/ending/cake.36$EXT"
cp "_temp/SUPER MARIO 64#E3A23A76#0#2_all$EXT" "$PORT/levels/ending/cake.44$EXT"
cp "_temp/SUPER MARIO 64#80443EAE#0#2_all$EXT" "$PORT/levels/ending/cake.11$EXT"
cp "_temp/SUPER MARIO 64#8202BE27#0#2_all$EXT" "$PORT/levels/ending/cake.21$EXT"
cp "_temp/SUPER MARIO 64#E3A23A76#0#2_all$EXT" "$PORT/levels/ending/cake.47$EXT"
cp "_temp/SUPER MARIO 64#8D5F88C4#0#2_all$EXT" "$PORT/levels/ending/cake.41$EXT"
cp "_temp/SUPER MARIO 64#992737D1#0#2_all$EXT" "$PORT/levels/ending/cake.32$EXT"
cp "_temp/SUPER MARIO 64#9BD37209#0#2_all$EXT" "$PORT/levels/ending/cake.18$EXT"
cp "_temp/SUPER MARIO 64#9C8D6967#0#2_all$EXT" "$PORT/levels/ending/cake.10$EXT"
cp "_temp/SUPER MARIO 64#A58A82F8#0#2_all$EXT" "$PORT/levels/ending/cake.19$EXT"
cp "_temp/SUPER MARIO 64#BA568BD1#0#2_all$EXT" "$PORT/levels/ending/cake.24$EXT"
cp "_temp/SUPER MARIO 64#BF00C323#0#2_all$EXT" "$PORT/levels/ending/cake.16$EXT"
cp "_temp/SUPER MARIO 64#C8782E13#0#2_all$EXT" "$PORT/levels/ending/cake.29$EXT"
cp "_temp/SUPER MARIO 64#D3D78F68#0#2_all$EXT" "$PORT/levels/ending/cake.9$EXT"
cp "_temp/SUPER MARIO 64#EC390C33#0#2_all$EXT" "$PORT/levels/ending/cake.35$EXT"
cp "_temp/SUPER MARIO 64#F3247D8B#0#2_all$EXT" "$PORT/levels/ending/cake.26$EXT"
cp "_temp/SUPER MARIO 64#F66738C7#0#2_all$EXT" "$PORT/levels/ending/cake.42$EXT"
cp "_temp/SUPER MARIO 64#F8B79A21#0#2_all$EXT" "$PORT/levels/ending/cake.4$EXT"
cp "_temp/SUPER MARIO 64#F8D3168E#0#2_all$EXT" "$PORT/levels/ending/cake.5$EXT"
cp "_temp/SUPER MARIO 64#FA49A60A#0#2_all$EXT" "$PORT/levels/ending/cake.15$EXT"
cp "_temp/SUPER MARIO 64#FA825D44#0#2_all$EXT" "$PORT/levels/ending/cake.12$EXT"
cp "_temp/SUPER MARIO 64#FBEC7687#0#2_all$EXT" "$PORT/levels/ending/cake.8$EXT"

cp "_temp/SUPER MARIO 64#014C6E73#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.34$EXT"
cp "_temp/SUPER MARIO 64#03EEAB38#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.27$EXT"
cp "_temp/SUPER MARIO 64#0BA8D96E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.17$EXT"
cp "_temp/SUPER MARIO 64#11A852CB#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.36$EXT"
cp "_temp/SUPER MARIO 64#221C9F08#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.62$EXT"
cp "_temp/SUPER MARIO 64#22628916#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.10$EXT"
cp "_temp/SUPER MARIO 64#24EC3198#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.35$EXT"
cp "_temp/SUPER MARIO 64#26A34F80#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.48$EXT"
cp "_temp/SUPER MARIO 64#32B61B3E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.53$EXT"
cp "_temp/SUPER MARIO 64#39C55C7F#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.26$EXT"
cp "_temp/SUPER MARIO 64#3CC93124#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.6$EXT"
cp "_temp/SUPER MARIO 64#3FFA0BE7#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.59$EXT"
cp "_temp/SUPER MARIO 64#40226C48#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.63$EXT"
cp "_temp/SUPER MARIO 64#46EE72E8#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.21$EXT"
cp "_temp/SUPER MARIO 64#51D0A5D0#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.7$EXT"
cp "_temp/SUPER MARIO 64#58F28A81#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.20$EXT"
cp "_temp/SUPER MARIO 64#5C293288#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.5$EXT"
cp "_temp/SUPER MARIO 64#5CC5CAF7#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.4$EXT"
cp "_temp/SUPER MARIO 64#64DF79E9#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.49$EXT"
cp "_temp/SUPER MARIO 64#6905FBF2#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.30$EXT"
cp "_temp/SUPER MARIO 64#6DB140AD#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.31$EXT"
cp "_temp/SUPER MARIO 64#74535372#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.22$EXT"
cp "_temp/SUPER MARIO 64#76F2D5AF#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.60$EXT"
cp "_temp/SUPER MARIO 64#77EC8240#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.38$EXT"
cp "_temp/SUPER MARIO 64#8076D349#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.24$EXT"
cp "_temp/SUPER MARIO 64#822B53ED#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.33$EXT"
cp "_temp/SUPER MARIO 64#82487DAB#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.28$EXT"
cp "_temp/SUPER MARIO 64#8541D92C#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.47$EXT"
cp "_temp/SUPER MARIO 64#86A4D0DC#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.51$EXT"
cp "_temp/SUPER MARIO 64#8726A741#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.25$EXT"
cp "_temp/SUPER MARIO 64#889E61FF#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.14$EXT"
cp "_temp/SUPER MARIO 64#88E7E346#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.43$EXT"
cp "_temp/SUPER MARIO 64#8B462047#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.45$EXT"
cp "_temp/SUPER MARIO 64#912F6E5E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.44$EXT"
cp "_temp/SUPER MARIO 64#92A6E121#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.46$EXT"
cp "_temp/SUPER MARIO 64#99A009D0#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.58$EXT"
cp "_temp/SUPER MARIO 64#9DBB856E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.54$EXT"
cp "_temp/SUPER MARIO 64#9F6BFF93#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.55$EXT"
cp "_temp/SUPER MARIO 64#9F82C465#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.41$EXT"
cp "_temp/SUPER MARIO 64#A3067F0B#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.52$EXT"
cp "_temp/SUPER MARIO 64#B0FE2869#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.42$EXT"
cp "_temp/SUPER MARIO 64#B1330909#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.11$EXT"
cp "_temp/SUPER MARIO 64#B858A9A4#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.29$EXT"
cp "_temp/SUPER MARIO 64#BB2FB09F#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.12$EXT"
cp "_temp/SUPER MARIO 64#BBED1DAD#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.18$EXT"
cp "_temp/SUPER MARIO 64#BDD76307#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.13$EXT"
cp "_temp/SUPER MARIO 64#BF89DF6A#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.37$EXT"
cp "_temp/SUPER MARIO 64#C9425D35#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.8$EXT"
cp "_temp/SUPER MARIO 64#CCAD2F1E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.3$EXT"
cp "_temp/SUPER MARIO 64#CCFB8478#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.40$EXT"
cp "_temp/SUPER MARIO 64#CD7A591F#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.2$EXT"
cp "_temp/SUPER MARIO 64#D2A5272B#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.19$EXT"
cp "_temp/SUPER MARIO 64#D68E7D47#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.16$EXT"
cp "_temp/SUPER MARIO 64#D742B346#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.15$EXT"
cp "_temp/SUPER MARIO 64#DA354D71#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.9$EXT"
cp "_temp/SUPER MARIO 64#DC5422CC#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.32$EXT"
cp "_temp/SUPER MARIO 64#DDCBD0BF#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.39$EXT"
cp "_temp/SUPER MARIO 64#DEEF869F#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.56$EXT"
cp "_temp/SUPER MARIO 64#E348762E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.50$EXT"
cp "_temp/SUPER MARIO 64#E47FB00E#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.1$EXT"
cp "_temp/SUPER MARIO 64#E702818C#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.61$EXT"
cp "_temp/SUPER MARIO 64#EB70D69C#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.23$EXT"
cp "_temp/SUPER MARIO 64#EF1D1E70#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.57$EXT"
cp "_temp/SUPER MARIO 64#F1301217#0#2_all$EXT" "$PORT/textures/skyboxes/ccm/ccm.0$EXT"

cp "_temp/SUPER MARIO 64#027C89DB#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.0$EXT"
cp "_temp/SUPER MARIO 64#02AADDF6#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.59$EXT"
cp "_temp/SUPER MARIO 64#031DC071#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.49$EXT"
cp "_temp/SUPER MARIO 64#05EC9E16#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.17$EXT"
cp "_temp/SUPER MARIO 64#0F1C2159#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.47$EXT"
cp "_temp/SUPER MARIO 64#212A4546#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.54$EXT"
cp "_temp/SUPER MARIO 64#24A049BD#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.31$EXT"
cp "_temp/SUPER MARIO 64#2D31F48B#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.10$EXT"
cp "_temp/SUPER MARIO 64#2DDB1AB2#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.61$EXT"
cp "_temp/SUPER MARIO 64#32DA5C54#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.48$EXT"
cp "_temp/SUPER MARIO 64#408779A6#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.26$EXT"
cp "_temp/SUPER MARIO 64#40AD9DAB#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.45$EXT"
cp "_temp/SUPER MARIO 64#48A5F126#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.1$EXT"
cp "_temp/SUPER MARIO 64#49A828DB#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.12$EXT"
cp "_temp/SUPER MARIO 64#54CA6DDC#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.40$EXT"
cp "_temp/SUPER MARIO 64#579B80B3#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.13$EXT"
cp "_temp/SUPER MARIO 64#579D6C8A#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.62$EXT"
cp "_temp/SUPER MARIO 64#57DD4DE0#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.34$EXT"
cp "_temp/SUPER MARIO 64#5D58D20C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.2$EXT"
cp "_temp/SUPER MARIO 64#613A2612#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.35$EXT"
cp "_temp/SUPER MARIO 64#626B987C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.57$EXT"
cp "_temp/SUPER MARIO 64#648DFFC2#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.42$EXT"
cp "_temp/SUPER MARIO 64#677CF935#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.43$EXT"
cp "_temp/SUPER MARIO 64#6D00C07C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.29$EXT"
cp "_temp/SUPER MARIO 64#71D8C330#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.18$EXT"
cp "_temp/SUPER MARIO 64#71FFBF4D#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.41$EXT"
cp "_temp/SUPER MARIO 64#74C13ED4#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.36$EXT"
cp "_temp/SUPER MARIO 64#76ABE6DB#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.51$EXT"
cp "_temp/SUPER MARIO 64#76F2963D#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.60$EXT"
cp "_temp/SUPER MARIO 64#7C98DFA7#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.14$EXT"
cp "_temp/SUPER MARIO 64#7E91D91E#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.37$EXT"
cp "_temp/SUPER MARIO 64#84651765#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.32$EXT"
cp "_temp/SUPER MARIO 64#86B5C15F#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.50$EXT"
cp "_temp/SUPER MARIO 64#880ED312#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.3$EXT"
cp "_temp/SUPER MARIO 64#889D2B5C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.4$EXT"
cp "_temp/SUPER MARIO 64#9FB76A34#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.38$EXT"
cp "_temp/SUPER MARIO 64#A356667C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.55$EXT"
cp "_temp/SUPER MARIO 64#A4908044#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.5$EXT"
cp "_temp/SUPER MARIO 64#A87F6678#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.44$EXT"
cp "_temp/SUPER MARIO 64#B09F7FF5#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.39$EXT"
cp "_temp/SUPER MARIO 64#B416574C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.24$EXT"
cp "_temp/SUPER MARIO 64#B484B601#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.6$EXT"
cp "_temp/SUPER MARIO 64#BA25C107#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.15$EXT"
cp "_temp/SUPER MARIO 64#C70E2879#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.23$EXT"
cp "_temp/SUPER MARIO 64#D3D96165#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.46$EXT"
cp "_temp/SUPER MARIO 64#D3F0D281#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.21$EXT"
cp "_temp/SUPER MARIO 64#D404F7B3#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.58$EXT"
cp "_temp/SUPER MARIO 64#D61DC576#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.11$EXT"
cp "_temp/SUPER MARIO 64#D8E02894#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.63$EXT"
cp "_temp/SUPER MARIO 64#E0901C5A#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.7$EXT"
cp "_temp/SUPER MARIO 64#E6640E91#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.30$EXT"
cp "_temp/SUPER MARIO 64#E747F9B9#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.19$EXT"
cp "_temp/SUPER MARIO 64#E7D08E45#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.56$EXT"
cp "_temp/SUPER MARIO 64#EB5C820F#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.27$EXT"
cp "_temp/SUPER MARIO 64#EBA48BA7#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.53$EXT"
cp "_temp/SUPER MARIO 64#EBA8BFCA#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.8$EXT"
cp "_temp/SUPER MARIO 64#EE5C9999#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.20$EXT"
cp "_temp/SUPER MARIO 64#F03AEF7D#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.28$EXT"
cp "_temp/SUPER MARIO 64#F05AADEE#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.52$EXT"
cp "_temp/SUPER MARIO 64#F0DD9D26#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.33$EXT"
cp "_temp/SUPER MARIO 64#F6BB8446#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.25$EXT"
cp "_temp/SUPER MARIO 64#FB04DE95#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.16$EXT"
cp "_temp/SUPER MARIO 64#FB4E7D3C#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.22$EXT"
cp "_temp/SUPER MARIO 64#FC424ECC#0#2_all$EXT" "$PORT/textures/skyboxes/cloud_floor/cloud_floor.9$EXT"

cp "_temp/SUPER MARIO 64#019BFB97#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.5$EXT"
cp "_temp/SUPER MARIO 64#02C423F8#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.12$EXT"
cp "_temp/SUPER MARIO 64#0A10018C#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.3$EXT"
cp "_temp/SUPER MARIO 64#0D344FC8#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.28$EXT"
cp "_temp/SUPER MARIO 64#214F09C8#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.14$EXT"
cp "_temp/SUPER MARIO 64#21676BDD#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.1$EXT"
cp "_temp/SUPER MARIO 64#2F3FDBA3#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.21$EXT"
cp "_temp/SUPER MARIO 64#40E6BBFB#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.10$EXT"
cp "_temp/SUPER MARIO 64#4A043C67#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.32$EXT"
cp "_temp/SUPER MARIO 64#540F30FF#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.27$EXT"
cp "_temp/SUPER MARIO 64#5A838C70#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.30$EXT"
cp "_temp/SUPER MARIO 64#6C064A7F#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.36$EXT"
cp "_temp/SUPER MARIO 64#6C42DFF7#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.0$EXT"
cp "_temp/SUPER MARIO 64#7F86B16B#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.8$EXT"
cp "_temp/SUPER MARIO 64#7FCD908D#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.26$EXT"
cp "_temp/SUPER MARIO 64#82C55DC1#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.15$EXT"
cp "_temp/SUPER MARIO 64#89AC3C05#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.11$EXT"
cp "_temp/SUPER MARIO 64#89CFD188#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.7$EXT"
cp "_temp/SUPER MARIO 64#8CC10B27#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.2$EXT"
cp "_temp/SUPER MARIO 64#98C45311#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.23$EXT"
cp "_temp/SUPER MARIO 64#98C99A4D#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.37$EXT"
cp "_temp/SUPER MARIO 64#A07BCDE0#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.20$EXT"
cp "_temp/SUPER MARIO 64#A1261BAA#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.31$EXT"
cp "_temp/SUPER MARIO 64#A5E5250E#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.17$EXT"
cp "_temp/SUPER MARIO 64#AACF41C9#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.35$EXT"
cp "_temp/SUPER MARIO 64#AB7A67D1#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.18$EXT"
cp "_temp/SUPER MARIO 64#C0A7D217#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.24$EXT"
cp "_temp/SUPER MARIO 64#C3941398#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.22$EXT"
cp "_temp/SUPER MARIO 64#C63F7ABB#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.19$EXT"
cp "_temp/SUPER MARIO 64#C96FD4B4#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.29$EXT"
cp "_temp/SUPER MARIO 64#CABC445D#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.16$EXT"
cp "_temp/SUPER MARIO 64#D658AB33#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.39$EXT"
cp "_temp/SUPER MARIO 64#D7B09499#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.6$EXT"
cp "_temp/SUPER MARIO 64#DB5B2455#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.13$EXT"
cp "_temp/SUPER MARIO 64#DC28412D#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.34$EXT"
cp "_temp/SUPER MARIO 64#E20D5C69#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.9$EXT"
cp "_temp/SUPER MARIO 64#EEB51695#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.33$EXT"
cp "_temp/SUPER MARIO 64#F0FD9FE8#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.38$EXT"
cp "_temp/SUPER MARIO 64#F19D33E5#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.25$EXT"
cp "_temp/SUPER MARIO 64#FDB6DE70#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.4$EXT"
cp "_temp/SUPER MARIO 64#45667AED#0#2_all$EXT" "$PORT/textures/skyboxes/clouds/clouds.40$EXT"

cp "_temp/SUPER MARIO 64#06AB9733#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.21$EXT"
cp "_temp/SUPER MARIO 64#074933DA#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.45$EXT"
cp "_temp/SUPER MARIO 64#082CD478#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.37$EXT"
cp "_temp/SUPER MARIO 64#101CA508#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.48$EXT"
cp "_temp/SUPER MARIO 64#11F1B791#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.20$EXT"
cp "_temp/SUPER MARIO 64#1411177B#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.24$EXT"
cp "_temp/SUPER MARIO 64#15B65397#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.23$EXT"
cp "_temp/SUPER MARIO 64#19CF329B#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.49$EXT"
cp "_temp/SUPER MARIO 64#1ADECD70#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.50$EXT"
cp "_temp/SUPER MARIO 64#213EBD50#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.15$EXT"
cp "_temp/SUPER MARIO 64#2193CD76#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.51$EXT"
cp "_temp/SUPER MARIO 64#2D6492F4#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.12$EXT"
cp "_temp/SUPER MARIO 64#32BEB053#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.6$EXT"
cp "_temp/SUPER MARIO 64#38EC1B66#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.29$EXT"
cp "_temp/SUPER MARIO 64#393BA6AE#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.34$EXT"
cp "_temp/SUPER MARIO 64#3C183177#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.52$EXT"
cp "_temp/SUPER MARIO 64#52749E6E#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.18$EXT"
cp "_temp/SUPER MARIO 64#52D5A8B9#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.1$EXT"
cp "_temp/SUPER MARIO 64#55EB7A33#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.33$EXT"
cp "_temp/SUPER MARIO 64#5F5E3DF7#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.46$EXT"
cp "_temp/SUPER MARIO 64#62AEFDE2#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.41$EXT"
cp "_temp/SUPER MARIO 64#6505FAC3#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.28$EXT"
cp "_temp/SUPER MARIO 64#67B3CF11#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.44$EXT"
cp "_temp/SUPER MARIO 64#6899F91F#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.4$EXT"
cp "_temp/SUPER MARIO 64#6A17A436#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.11$EXT"
cp "_temp/SUPER MARIO 64#6D0C18AA#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.53$EXT"
cp "_temp/SUPER MARIO 64#75EF9A90#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.8$EXT"
cp "_temp/SUPER MARIO 64#79C8997D#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.14$EXT"
cp "_temp/SUPER MARIO 64#7E1D47DB#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.54$EXT"
cp "_temp/SUPER MARIO 64#7E27E43F#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.17$EXT"
cp "_temp/SUPER MARIO 64#85A91338#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.13$EXT"
cp "_temp/SUPER MARIO 64#914AFA93#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.55$EXT"
cp "_temp/SUPER MARIO 64#91787803#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.26$EXT"
cp "_temp/SUPER MARIO 64#96FAD568#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.19$EXT"
cp "_temp/SUPER MARIO 64#9BF7992D#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.25$EXT"
cp "_temp/SUPER MARIO 64#A0A0A907#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.56$EXT"
cp "_temp/SUPER MARIO 64#A34577B4#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.42$EXT"
cp "_temp/SUPER MARIO 64#A4B86DC8#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.0$EXT"
cp "_temp/SUPER MARIO 64#A4C2448B#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.40$EXT"
cp "_temp/SUPER MARIO 64#A6D0D0CC#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.57$EXT"
cp "_temp/SUPER MARIO 64#AFCC9DE7#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.7$EXT"
cp "_temp/SUPER MARIO 64#B0A791EE#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.39$EXT"
cp "_temp/SUPER MARIO 64#B1E98F62#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.32$EXT"
cp "_temp/SUPER MARIO 64#B3C88877#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.58$EXT"
cp "_temp/SUPER MARIO 64#B44A7CEF#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.59$EXT"
cp "_temp/SUPER MARIO 64#B48BB452#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.9$EXT"
cp "_temp/SUPER MARIO 64#B55E9B94#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.36$EXT"
cp "_temp/SUPER MARIO 64#B7C222A8#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.43$EXT"
cp "_temp/SUPER MARIO 64#B8378CD9#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.3$EXT"
cp "_temp/SUPER MARIO 64#BD8C842F#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.22$EXT"
cp "_temp/SUPER MARIO 64#BDC75108#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.60$EXT"
cp "_temp/SUPER MARIO 64#C6D80BAF#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.47$EXT"
cp "_temp/SUPER MARIO 64#C8922002#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.2$EXT"
cp "_temp/SUPER MARIO 64#CB3C5D47#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.38$EXT"
cp "_temp/SUPER MARIO 64#CEA7425D#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.5$EXT"
cp "_temp/SUPER MARIO 64#D26EE300#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.30$EXT"
cp "_temp/SUPER MARIO 64#DBA34B25#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.35$EXT"
cp "_temp/SUPER MARIO 64#DDD906E3#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.61$EXT"
cp "_temp/SUPER MARIO 64#DF68E5A6#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.27$EXT"
cp "_temp/SUPER MARIO 64#F16F1966#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.62$EXT"
cp "_temp/SUPER MARIO 64#F4472DB5#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.63$EXT"
cp "_temp/SUPER MARIO 64#F765D232#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.16$EXT"
cp "_temp/SUPER MARIO 64#FDC48AEB#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.10$EXT"
cp "_temp/SUPER MARIO 64#FF6C67F0#0#2_all$EXT" "$PORT/textures/skyboxes/ssl/ssl.31$EXT"

cp "_temp/SUPER MARIO 64#011C8C77#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.23$EXT"
cp "_temp/SUPER MARIO 64#08170B98#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.59$EXT"
cp "_temp/SUPER MARIO 64#0DDC6F87#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.29$EXT"
cp "_temp/SUPER MARIO 64#1096C02E#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.56$EXT"
cp "_temp/SUPER MARIO 64#112C8257#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.44$EXT"
cp "_temp/SUPER MARIO 64#1465E49F#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.24$EXT"
cp "_temp/SUPER MARIO 64#19132BCC#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.6$EXT"
cp "_temp/SUPER MARIO 64#1A66C67F#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.43$EXT"
cp "_temp/SUPER MARIO 64#1CA18F8F#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.61$EXT"
cp "_temp/SUPER MARIO 64#1E940DB1#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.12$EXT"
cp "_temp/SUPER MARIO 64#1EED9296#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.36$EXT"
cp "_temp/SUPER MARIO 64#208F2137#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.19$EXT"
cp "_temp/SUPER MARIO 64#21DD7803#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.58$EXT"
cp "_temp/SUPER MARIO 64#2499CE37#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.50$EXT"
cp "_temp/SUPER MARIO 64#24D27245#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.0$EXT"
cp "_temp/SUPER MARIO 64#258A8627#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.46$EXT"
cp "_temp/SUPER MARIO 64#29904548#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.63$EXT"
cp "_temp/SUPER MARIO 64#2E5DD16D#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.7$EXT"
cp "_temp/SUPER MARIO 64#3AADB102#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.16$EXT"
cp "_temp/SUPER MARIO 64#3AE6BEC9#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.47$EXT"
cp "_temp/SUPER MARIO 64#3D21394E#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.39$EXT"
cp "_temp/SUPER MARIO 64#3D244F64#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.55$EXT"
cp "_temp/SUPER MARIO 64#3D354167#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.42$EXT"
cp "_temp/SUPER MARIO 64#4089D798#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.17$EXT"
cp "_temp/SUPER MARIO 64#45F63AE1#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.60$EXT"
cp "_temp/SUPER MARIO 64#48BC2FC8#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.57$EXT"
cp "_temp/SUPER MARIO 64#4BCAE8D6#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.22$EXT"
cp "_temp/SUPER MARIO 64#4D606A9B#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.45$EXT"
cp "_temp/SUPER MARIO 64#53CBF3E0#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.33$EXT"
cp "_temp/SUPER MARIO 64#5643908B#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.25$EXT"
cp "_temp/SUPER MARIO 64#5730FAAA#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.35$EXT"
cp "_temp/SUPER MARIO 64#599DA7CB#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.27$EXT"
cp "_temp/SUPER MARIO 64#5A2FA13A#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.31$EXT"
cp "_temp/SUPER MARIO 64#60DD861C#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.14$EXT"
cp "_temp/SUPER MARIO 64#65ABBFE9#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.30$EXT"
cp "_temp/SUPER MARIO 64#6ACA7D17#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.38$EXT"
cp "_temp/SUPER MARIO 64#6F146752#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.51$EXT"
cp "_temp/SUPER MARIO 64#7CB09E26#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.34$EXT"
cp "_temp/SUPER MARIO 64#7D23E625#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.15$EXT"
cp "_temp/SUPER MARIO 64#87C25FE2#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.40$EXT"
cp "_temp/SUPER MARIO 64#8AF0E7BE#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.1$EXT"
cp "_temp/SUPER MARIO 64#8E58D68A#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.49$EXT"
cp "_temp/SUPER MARIO 64#8F92529C#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.5$EXT"
cp "_temp/SUPER MARIO 64#933976B9#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.26$EXT"
cp "_temp/SUPER MARIO 64#942949F4#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.18$EXT"
cp "_temp/SUPER MARIO 64#96A88F3B#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.3$EXT"
cp "_temp/SUPER MARIO 64#9D13156E#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.8$EXT"
cp "_temp/SUPER MARIO 64#A608942F#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.4$EXT"
cp "_temp/SUPER MARIO 64#A9DE87A8#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.41$EXT"
cp "_temp/SUPER MARIO 64#B6CEC061#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.28$EXT"
cp "_temp/SUPER MARIO 64#B8755755#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.11$EXT"
cp "_temp/SUPER MARIO 64#B8E3120B#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.2$EXT"
cp "_temp/SUPER MARIO 64#C3EB2FC6#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.54$EXT"
cp "_temp/SUPER MARIO 64#DB3EDFED#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.13$EXT"
cp "_temp/SUPER MARIO 64#DBC08093#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.10$EXT"
cp "_temp/SUPER MARIO 64#DDE2C14F#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.20$EXT"
cp "_temp/SUPER MARIO 64#E04EF9FC#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.21$EXT"
cp "_temp/SUPER MARIO 64#E169C3BF#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.9$EXT"
cp "_temp/SUPER MARIO 64#E447E6B0#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.48$EXT"
cp "_temp/SUPER MARIO 64#E8F6FFF7#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.62$EXT"
cp "_temp/SUPER MARIO 64#EDFF0BD2#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.37$EXT"
cp "_temp/SUPER MARIO 64#EF35DA31#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.32$EXT"
cp "_temp/SUPER MARIO 64#F10816C6#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.52$EXT"
cp "_temp/SUPER MARIO 64#FC489936#0#2_all$EXT" "$PORT/textures/skyboxes/water/water.53$EXT"

cp "_temp/SUPER MARIO 64#006A1516#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.58$EXT"
cp "_temp/SUPER MARIO 64#0374425D#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.26$EXT"
cp "_temp/SUPER MARIO 64#0391EE74#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.24$EXT"
cp "_temp/SUPER MARIO 64#07059F23#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.51$EXT"
cp "_temp/SUPER MARIO 64#0731BEEA#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.44$EXT"
cp "_temp/SUPER MARIO 64#0A45EF5B#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.48$EXT"
cp "_temp/SUPER MARIO 64#0BE35913#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.4$EXT"
cp "_temp/SUPER MARIO 64#0E1E7EB2#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.56$EXT"
cp "_temp/SUPER MARIO 64#0FF0D650#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.10$EXT"
cp "_temp/SUPER MARIO 64#12C0F052#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.8$EXT"
cp "_temp/SUPER MARIO 64#158AA64C#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.18$EXT"
cp "_temp/SUPER MARIO 64#16733B9A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.17$EXT"
cp "_temp/SUPER MARIO 64#19D0A651#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.36$EXT"
cp "_temp/SUPER MARIO 64#1B1FA1C6#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.30$EXT"
cp "_temp/SUPER MARIO 64#2B8359BB#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.0$EXT"
cp "_temp/SUPER MARIO 64#385055F4#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.37$EXT"
cp "_temp/SUPER MARIO 64#397F1DA4#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.19$EXT"
cp "_temp/SUPER MARIO 64#3CFBA273#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.62$EXT"
cp "_temp/SUPER MARIO 64#3EC818DE#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.11$EXT"
cp "_temp/SUPER MARIO 64#41590B79#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.23$EXT"
cp "_temp/SUPER MARIO 64#465F9B72#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.49$EXT"
cp "_temp/SUPER MARIO 64#4F3ECE62#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.38$EXT"
cp "_temp/SUPER MARIO 64#56450E91#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.55$EXT"
cp "_temp/SUPER MARIO 64#5A1A4FBF#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.52$EXT"
cp "_temp/SUPER MARIO 64#5E2B9C03#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.6$EXT"
cp "_temp/SUPER MARIO 64#6A8BF6A8#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.32$EXT"
cp "_temp/SUPER MARIO 64#6D1039D9#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.16$EXT"
cp "_temp/SUPER MARIO 64#6DF82BBE#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.14$EXT"
cp "_temp/SUPER MARIO 64#7889781A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.61$EXT"
cp "_temp/SUPER MARIO 64#8675F075#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.1$EXT"
cp "_temp/SUPER MARIO 64#8853B016#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.12$EXT"
cp "_temp/SUPER MARIO 64#92E17E06#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.3$EXT"
cp "_temp/SUPER MARIO 64#940954AC#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.40$EXT"
cp "_temp/SUPER MARIO 64#98DAF219#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.63$EXT"
cp "_temp/SUPER MARIO 64#A3936EE4#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.43$EXT"
cp "_temp/SUPER MARIO 64#A554538A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.54$EXT"
cp "_temp/SUPER MARIO 64#A6592F52#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.34$EXT"
cp "_temp/SUPER MARIO 64#A6C56AA3#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.7$EXT"
cp "_temp/SUPER MARIO 64#A72C7C50#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.46$EXT"
cp "_temp/SUPER MARIO 64#A742C5E3#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.60$EXT"
cp "_temp/SUPER MARIO 64#A84756AE#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.47$EXT"
cp "_temp/SUPER MARIO 64#B3B76BCE#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.15$EXT"
cp "_temp/SUPER MARIO 64#BFC9A9DD#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.5$EXT"
cp "_temp/SUPER MARIO 64#CBAB007A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.39$EXT"
cp "_temp/SUPER MARIO 64#CD56C1F2#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.42$EXT"
cp "_temp/SUPER MARIO 64#CFB45CAF#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.20$EXT"
cp "_temp/SUPER MARIO 64#D13A97C9#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.13$EXT"
cp "_temp/SUPER MARIO 64#D3EA4D38#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.28$EXT"
cp "_temp/SUPER MARIO 64#D4C2DC38#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.25$EXT"
cp "_temp/SUPER MARIO 64#D8F79383#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.21$EXT"
cp "_temp/SUPER MARIO 64#DA83E7AB#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.9$EXT"
cp "_temp/SUPER MARIO 64#DB4B54D5#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.22$EXT"
cp "_temp/SUPER MARIO 64#DDE6049E#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.59$EXT"
cp "_temp/SUPER MARIO 64#DE5450B9#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.50$EXT"
cp "_temp/SUPER MARIO 64#E01B30F4#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.41$EXT"
cp "_temp/SUPER MARIO 64#E075472A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.53$EXT"
cp "_temp/SUPER MARIO 64#F0EDEA43#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.57$EXT"
cp "_temp/SUPER MARIO 64#F2EDE87D#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.31$EXT"
cp "_temp/SUPER MARIO 64#F37A7379#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.2$EXT"
cp "_temp/SUPER MARIO 64#F5013C4A#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.45$EXT"
cp "_temp/SUPER MARIO 64#F566B5FA#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.33$EXT"
cp "_temp/SUPER MARIO 64#F861446C#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.35$EXT"
cp "_temp/SUPER MARIO 64#F8CAB46C#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.29$EXT"
cp "_temp/SUPER MARIO 64#FEB13915#0#2_all$EXT" "$PORT/textures/skyboxes/wdw/wdw.27$EXT"

cp "_temp/SUPER MARIO 64#6543184D#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#84FED0D8#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#3909F67D#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.01000$EXT"
cp "_temp/SUPER MARIO 64#9678001C#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.02000$EXT"
cp "_temp/SUPER MARIO 64#744A7D8E#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#9B6B4DBC#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.03000$EXT"
cp "_temp/SUPER MARIO 64#FED5AB03#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#56DA6B66#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.04000$EXT"
cp "_temp/SUPER MARIO 64#9CAB9C3A#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#F831589E#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#E9E0C62A#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#E1CA8B50#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#8DB2E5CA#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#038BE28F#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#130CA9A8#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#E8E37186#0#2_all$EXT" "$PORT/textures/snow/ccm_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#17EA3392#3#2_all$EXT" "$PORT/textures/snow/ccm_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#252A4B98#3#2_all$EXT" "$PORT/textures/snow/ccm_textures.09800$EXT"

cp "_temp/SUPER MARIO 64#A4AF5230#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#B5B2C148#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#BD28248A#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#042DEE1B#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#15D30589#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#8899587D#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#4A4683BC#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#3157CD18#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.05000$EXT"
cp "_temp/SUPER MARIO 64#B8F6006F#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#FFF8437E#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#78AB0F9F#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.07000$EXT"
cp "_temp/SUPER MARIO 64#C9E2883E#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.08000$EXT"
cp "_temp/SUPER MARIO 64#0AD7A8F7#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#C99707D9#0#2_all$EXT" "$PORT/textures/spooky/bbh_textures.09000$EXT"
cp "_temp/SUPER MARIO 64#6C3CE89F#3#2_all$EXT" "$PORT/textures/spooky/bbh_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#F0A134BD#3#2_all$EXT" "$PORT/textures/spooky/bbh_textures.0B000$EXT"
cp "_temp/SUPER MARIO 64#2EB2480C#3#2_all$EXT" "$PORT/textures/spooky/bbh_textures.0B800$EXT"

cp "_temp/SUPER MARIO 64#17EB8CF3#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.00E40$EXT"
cp "_temp/SUPER MARIO 64#530A2CF4#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.001C0$EXT"
cp "_temp/SUPER MARIO 64#8B826DF7#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.01AC0$EXT"
cp "_temp/SUPER MARIO 64#57A58C22#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.02740$EXT"
cp "_temp/SUPER MARIO 64#BB980031#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.033C0$EXT"
cp "_temp/SUPER MARIO 64#75701F22#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.04CC0$EXT"
cp "_temp/SUPER MARIO 64#8ECFFABB#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.04040$EXT"
cp "_temp/SUPER MARIO 64#563280BD#0#2_all$EXT" "$PORT/textures/title_screen_bg/title_screen_bg.05940$EXT"

cp "_temp/SUPER MARIO 64#E3C3F224#0#2_all$EXT" "$PORT/textures/water/jrb_textures.0A000$EXT"
cp "_temp/SUPER MARIO 64#6879F1F6#0#2_all$EXT" "$PORT/textures/water/jrb_textures.0A800$EXT"
cp "_temp/SUPER MARIO 64#7E28666B#0#2_all$EXT" "$PORT/textures/water/jrb_textures.0B800$EXT"
cp "_temp/SUPER MARIO 64#B5135C61#0#2_all$EXT" "$PORT/textures/water/jrb_textures.00000$EXT"
cp "_temp/SUPER MARIO 64#428BEF9C#0#2_all$EXT" "$PORT/textures/water/jrb_textures.00800$EXT"
cp "_temp/SUPER MARIO 64#5C403031#0#2_all$EXT" "$PORT/textures/water/jrb_textures.01800$EXT"
cp "_temp/SUPER MARIO 64#775A5057#0#2_all$EXT" "$PORT/textures/water/jrb_textures.02800$EXT"
cp "_temp/SUPER MARIO 64#2B644522#0#2_all$EXT" "$PORT/textures/water/jrb_textures.03800$EXT"
cp "_temp/SUPER MARIO 64#A1AE1A01#0#2_all$EXT" "$PORT/textures/water/jrb_textures.04800$EXT"
cp "_temp/SUPER MARIO 64#579C53ED#0#2_all$EXT" "$PORT/textures/water/jrb_textures.05800$EXT"
cp "_temp/SUPER MARIO 64#FEBEDAE8#0#2_all$EXT" "$PORT/textures/water/jrb_textures.06000$EXT"
cp "_temp/SUPER MARIO 64#1A808DA7#0#2_all$EXT" "$PORT/textures/water/jrb_textures.06800$EXT"
cp "_temp/SUPER MARIO 64#C3459917#0#2_all$EXT" "$PORT/textures/water/jrb_textures.07800$EXT"
cp "_temp/SUPER MARIO 64#6108550A#0#2_all$EXT" "$PORT/textures/water/jrb_textures.08800$EXT"
cp "_temp/SUPER MARIO 64#9C0E821E#0#2_all$EXT" "$PORT/textures/water/jrb_textures.09000$EXT"
